/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.Globals;

public class AutoDetectPaths
extends AbstractWorker {
    private boolean foundPaths = false;
    private boolean fileSearchCancelled = false;
    private JDialog prog;
    private final JDialog parent;

    public AutoDetectPaths(JDialog jDialog) {
        this.parent = jDialog;
    }

    public boolean runAutodetection() {
        try {
            if (AutoDetectPaths.checkAutoDetectedPaths()) {
                return true;
            }
            this.init();
            this.getWorker().run();
            this.update();
            return this.foundPaths;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        this.foundPaths = this.autoDetectPaths();
    }

    public boolean getResult() {
        return this.foundPaths;
    }

    public boolean cancelled() {
        return this.fileSearchCancelled;
    }

    @Override
    public void init() throws Throwable {
        this.prog = this.showProgressDialog(this.parent, Globals.lang("Autodetecting paths..."), Globals.lang("Please wait..."), true);
    }

    @Override
    public void update() {
        this.prog.dispose();
    }

    private boolean autoDetectPaths() {
        if (Globals.ON_WIN) {
            File jRadioButton;
            List<File> list = AutoDetectPaths.findProgramFilesDir();
            File file2 = null;
            if (this.fileSearchCancelled) {
                return false;
            }
            Iterator<File> object = list.iterator();
            while (object.hasNext() && (file2 = this.findFileDir(jRadioButton = object.next(), "soffice.exe")) == null) {
            }
            if (file2 == null) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("Unable to autodetect OpenOffice installation. Please choose the installation directory manually."), Globals.lang("Could not find OpenOffice installation"), 1);
                JFileChooser object2 = new JFileChooser(new File("C:\\"));
                object2.setDialogType(0);
                object2.setFileFilter(new javax.swing.filechooser.FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Globals.lang("Directories");
                    }
                });
                object2.setFileSelectionMode(1);
                object2.showOpenDialog(this.parent);
                if (object2.getSelectedFile() != null) {
                    file2 = object2.getSelectedFile();
                }
            }
            if (file2 == null) {
                return false;
            }
            Globals.prefs.put("ooExecutablePath", new File(file2, "soffice.exe").getPath());
            File file = this.findFileDir(file2.getParentFile(), "unoil.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            jRadioButton = this.findFileDir(file2.getParentFile(), "jurt.jar");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (file != null && jRadioButton != null) {
                Globals.prefs.put("ooUnoilPath", file.getPath());
                Globals.prefs.put("ooJurtPath", jRadioButton.getPath());
                return true;
            }
            return false;
        }
        if (Globals.ON_MAC) {
            File[] fileArray;
            File file = new File("/Applications");
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isDirectory() || !file2.getName().equals("OpenOffice.org.app")) continue;
                file = file2;
                break;
            }
            File file3 = this.findFileDir(file, "soffice.bin");
            if (this.fileSearchCancelled) {
                return false;
            }
            if (file3 != null) {
                Globals.prefs.put("ooExecutablePath", new File(file3, "soffice.bin").getPath());
                File file4 = this.findFileDir(file, "unoil.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                File file5 = this.findFileDir(file, "jurt.jar");
                if (this.fileSearchCancelled) {
                    return false;
                }
                if (file4 != null && file5 != null) {
                    Globals.prefs.put("ooUnoilPath", file4.getPath());
                    Globals.prefs.put("ooJurtPath", file5.getPath());
                    return true;
                }
                return false;
            }
            return false;
        }
        String string = "/usr/lib";
        File file = this.findFileDir(new File("/usr/lib"), "soffice");
        if (this.fileSearchCancelled) {
            return false;
        }
        if (file == null && (file = this.findFileDir(new File("/usr/lib64"), "soffice")) != null) {
            string = "/usr/lib64";
        }
        if (this.fileSearchCancelled) {
            return false;
        }
        File file6 = this.findFileDir(new File("/opt"), "soffice");
        if (this.fileSearchCancelled) {
            return false;
        }
        if (file != null && file6 == null) {
            return this.setupPreferencesForOO(string, file);
        }
        if (file6 != null && file == null) {
            Globals.prefs.put("ooExecutablePath", new File(file6, "soffice.bin").getPath());
            File file7 = this.findFileDir(new File("/opt"), "unoil.jar");
            File file8 = this.findFileDir(new File("/opt"), "jurt.jar");
            if (file7 != null && file8 != null) {
                Globals.prefs.put("ooUnoilPath", file7.getPath());
                Globals.prefs.put("ooJurtPath", file8.getPath());
                return true;
            }
            return false;
        }
        if (file6 != null) {
            JRadioButton jRadioButton = new JRadioButton(file6.getPath(), true);
            JRadioButton jRadioButton2 = new JRadioButton(file.getPath(), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref", ""));
            defaultFormBuilder.append(Globals.lang("Found more than one OpenOffice executable. Please choose which one to connect to:"));
            defaultFormBuilder.append(jRadioButton);
            defaultFormBuilder.append(jRadioButton2);
            int n = JOptionPane.showConfirmDialog(null, defaultFormBuilder.getPanel(), Globals.lang("Choose OpenOffice executable"), 2);
            if (n == 2) {
                return false;
            }
            if (jRadioButton.isSelected()) {
                return this.setupPreferencesForOO("/opt", file6);
            }
            return this.setupPreferencesForOO(string, file);
        }
        return false;
    }

    private boolean setupPreferencesForOO(String string, File file) {
        Globals.prefs.put("ooExecutablePath", new File(file, "soffice.bin").getPath());
        File file2 = this.findFileDir(new File(string), "unoil.jar");
        if (this.fileSearchCancelled) {
            return false;
        }
        File file3 = this.findFileDir(new File(string), "jurt.jar");
        if (this.fileSearchCancelled) {
            return false;
        }
        if (file2 != null && file3 != null) {
            Globals.prefs.put("ooUnoilPath", file2.getPath());
            Globals.prefs.put("ooJurtPath", file3.getPath());
            return true;
        }
        return false;
    }

    private static List<File> findProgramFilesDir() {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File("C:\\");
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            if (!file2.getName().toLowerCase().equals("program files") && !file2.getName().toLowerCase().equals("program files (x86)")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private static boolean checkAutoDetectedPaths() {
        if (Globals.prefs.hasKey("ooUnoilPath") && Globals.prefs.hasKey("ooJurtPath") && Globals.prefs.hasKey("ooExecutablePath")) {
            return new File(Globals.prefs.get("ooUnoilPath"), "unoil.jar").exists() && new File(Globals.prefs.get("ooJurtPath"), "jurt.jar").exists() && new File(Globals.prefs.get("ooExecutablePath")).exists();
        }
        return false;
    }

    private File findFileDir(File file, String string) {
        if (this.fileSearchCancelled) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        File file2 = null;
        for (File file3 : fileArray) {
            if (this.fileSearchCancelled) {
                return null;
            }
            if (file3.isDirectory()) {
                file2 = this.findFileDir(file3, string);
                if (file2 == null) continue;
                break;
            }
            if (!file3.getName().equals(string)) continue;
            file2 = file;
            break;
        }
        return file2;
    }

    public JDialog showProgressDialog(JDialog jDialog, String string, String string2, boolean bl) {
        this.fileSearchCancelled = false;
        JProgressBar jProgressBar = new JProgressBar(0);
        JButton jButton = new JButton(Globals.lang("Cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoDetectPaths.this.fileSearchCancelled = true;
                ((JButton)actionEvent.getSource()).setEnabled(false);
            }
        });
        JDialog jDialog2 = new JDialog(jDialog, string, false);
        jProgressBar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jProgressBar.setIndeterminate(true);
        if (bl) {
            jDialog2.add((Component)jButton, "South");
        }
        jDialog2.add((Component)new JLabel(string2), "North");
        jDialog2.add((Component)jProgressBar, "Center");
        jDialog2.pack();
        jDialog2.setLocationRelativeTo(null);
        jDialog2.setVisible(true);
        return jDialog2;
    }
}

