/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.bst.VM;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.format.FormatChars;
import org.antlr.runtime.RecognitionException;

class BstWrapper {
    private final LayoutFormatter formatter = new FormatChars();
    private VM vm = null;
    private static final Pattern bibitemTag = Pattern.compile("\\\\[a-zA-Z]*item\\{.*\\}");

    public void loadBstFile(File file) throws IOException, RecognitionException {
        this.vm = new VM(file);
    }

    public Map<String, String> processEntries(Collection<BibtexEntry> collection, BibtexDatabase bibtexDatabase) {
        String string = this.vm.run(collection);
        return this.parseResult(string);
    }

    private Map<String, String> parseResult(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Matcher matcher = bibitemTag.matcher(string);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (matcher.find()) {
            if (arrayList.size() > 0) {
                arrayList2.add(matcher.start());
            }
            System.out.println(matcher.start() + "  " + matcher.end());
            String string2 = matcher.group();
            String string3 = string2.substring(9, string2.length() - 1);
            arrayList.add(matcher.end());
            arrayList3.add(string3);
        }
        int n = string.lastIndexOf("\\end{thebibliography}");
        if (n > 0 && n > (Integer)arrayList.get(arrayList.size() - 1)) {
            arrayList2.add(n);
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            String string4 = (String)arrayList3.get(i);
            int n2 = (Integer)arrayList.get(i);
            int n3 = (Integer)arrayList2.get(i);
            String string5 = string.substring(n2, n3);
            hashMap.put(string4, this.formatter.format(string5.trim().replaceAll("\\\\newblock ", " ")));
        }
        return hashMap;
    }
}

