/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.oo.OOBibStyle;
import net.sf.jabref.util.Util;

class StyleSelectDialog {
    private static final String STYLE_FILE_EXTENSION = ".jstyle";
    private final JabRefFrame frame;
    private EventList<OOBibStyle> styles;
    private JDialog diag;
    private JTable table;
    private final JSplitPane contentPane = new JSplitPane(0);
    private EventTableModel<OOBibStyle> tableModel;
    private EventSelectionModel<OOBibStyle> selectionModel;
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem edit = new JMenuItem(Globals.lang("Edit"));
    private final JRadioButton useDefaultAuthoryear = new JRadioButton(Globals.lang("Default style (author-year citations)"));
    private final JRadioButton useDefaultNumerical = new JRadioButton(Globals.lang("Default style (numerical citations)"));
    private final JRadioButton chooseDirectly = new JRadioButton(Globals.lang("Choose style file directly") + ":");
    private final JRadioButton setDirectory = new JRadioButton(Globals.lang("Choose from a directory") + ":");
    private final JTextField directFile = new JTextField();
    private final JTextField styleDir = new JTextField();
    private final JButton browseDirectFile = new JButton(Globals.lang("Browse"));
    private final JButton browseStyleDir = new JButton(Globals.lang("Browse"));
    private final JButton showDefaultAuthoryearStyle = new JButton(Globals.lang("View"));
    private final JButton showDefaultNumericalStyle = new JButton(Globals.lang("View"));
    private PreviewPanel preview;
    private final Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private final BibtexEntry prevEntry = new BibtexEntry(IdGenerator.next());
    private boolean okPressed = false;
    private String initSelection;

    public StyleSelectDialog(JabRefFrame jabRefFrame, String string) {
        this.frame = jabRefFrame;
        this.setupPrevEntry();
        this.init(string);
    }

    private void init(String string) {
        this.initSelection = string;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useDefaultAuthoryear);
        buttonGroup.add(this.useDefaultNumerical);
        buttonGroup.add(this.chooseDirectly);
        buttonGroup.add(this.setDirectory);
        if (Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle")) {
            this.useDefaultAuthoryear.setSelected(true);
        } else if (Globals.prefs.getBoolean("ooUseDefaultNumericalStyle")) {
            this.useDefaultNumerical.setSelected(true);
        } else if (Globals.prefs.getBoolean("ooChooseStyleDirectly")) {
            this.chooseDirectly.setSelected(true);
        } else {
            this.setDirectory.setSelected(true);
        }
        this.directFile.setText(Globals.prefs.get("ooDirectFile"));
        this.styleDir.setText(Globals.prefs.get("ooStyleDirectory"));
        this.directFile.setEditable(false);
        this.styleDir.setEditable(false);
        this.popup.add(this.edit);
        BrowseAction browseAction = BrowseAction.buildForFile(this.directFile, this.directFile);
        this.browseDirectFile.addActionListener(browseAction);
        BrowseAction browseAction2 = BrowseAction.buildForDir(this.styleDir, this.setDirectory);
        this.browseStyleDir.addActionListener(browseAction2);
        this.showDefaultAuthoryearStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleSelectDialog.this.displayDefaultStyle(true);
            }
        });
        this.showDefaultNumericalStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleSelectDialog.this.displayDefaultStyle(false);
            }
        });
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = StyleSelectDialog.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByExt("jstyle");
                String string = ((OOBibStyle)StyleSelectDialog.this.tableModel.getElementAt(n)).getFile().getPath();
                try {
                    if (externalFileType != null) {
                        Util.openExternalFileAnyFormat(new MetaData(), string, externalFileType);
                    } else {
                        Util.openExternalFileUnknown(StyleSelectDialog.this.frame, null, new MetaData(), string, new UnknownExternalFileType("jstyle"));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        this.diag = new JDialog(this.frame, Globals.lang("Styles"), true);
        this.styles = new BasicEventList<OOBibStyle>();
        SortedList<OOBibStyle> sortedList = new SortedList<OOBibStyle>(this.styles);
        this.preview = new PreviewPanel(null, new MetaData(), "");
        this.preview.setEntry(this.prevEntry);
        this.tableModel = new EventTableModel<OOBibStyle>(sortedList, new StyleTableFormat());
        this.table = new JTable(this.tableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setPreferredWidth(80);
        this.selectionModel = new EventSelectionModel<OOBibStyle>(sortedList);
        this.table.setSelectionModel(this.selectionModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StyleSelectDialog.this.tablePopup(mouseEvent);
                }
            }
        });
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.styleDir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.readStyles();
                StyleSelectDialog.this.setDirectory.setSelected(true);
            }
        });
        this.directFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StyleSelectDialog.this.chooseDirectly.setSelected(true);
            }
        });
        this.contentPane.setTopComponent(new JScrollPane(this.table));
        this.contentPane.setBottomComponent(this.preview);
        this.readStyles();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref,4dlu,fill:150dlu,4dlu,fill:pref", ""));
        defaultFormBuilder.append((Component)this.useDefaultAuthoryear, 3);
        defaultFormBuilder.append(this.showDefaultAuthoryearStyle);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.useDefaultNumerical, 3);
        defaultFormBuilder.append(this.showDefaultNumericalStyle);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.chooseDirectly);
        defaultFormBuilder.append(this.directFile);
        defaultFormBuilder.append(this.browseDirectFile);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.setDirectory);
        defaultFormBuilder.append(this.styleDir);
        defaultFormBuilder.append(this.browseStyleDir);
        defaultFormBuilder.nextLine();
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("fill:1dlu:grow", "fill:pref, fill:pref, fill:270dlu:grow"));
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(new JLabel("<html>" + Globals.lang("This is the list of available styles. Select the one you want to use.") + "</html>"));
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(this.contentPane);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder2.getPanel().setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        this.diag.add((Component)defaultFormBuilder.getPanel(), "North");
        this.diag.add((Component)defaultFormBuilder2.getPanel(), "Center");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!StyleSelectDialog.this.useDefaultAuthoryear.isSelected() && !StyleSelectDialog.this.useDefaultNumerical.isSelected()) {
                    if (StyleSelectDialog.this.chooseDirectly.isSelected()) {
                        File file = new File(StyleSelectDialog.this.directFile.getText());
                        if (!file.exists()) {
                            JOptionPane.showMessageDialog(StyleSelectDialog.this.diag, Globals.lang("You must select either a valid style file, or use a default style."), Globals.lang("Style selection"), 0);
                            return;
                        }
                    } else if (StyleSelectDialog.this.table.getRowCount() == 0 || StyleSelectDialog.this.table.getSelectedRowCount() == 0) {
                        JOptionPane.showMessageDialog(StyleSelectDialog.this.diag, Globals.lang("You must select either a valid style file, or use a default style."), Globals.lang("Style selection"), 0);
                        return;
                    }
                }
                StyleSelectDialog.this.okPressed = true;
                StyleSelectDialog.this.storeSettings();
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleSelectDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction2);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)buttonBarBuilder.getPanel(), "South");
        ActionMap actionMap = buttonBarBuilder.getPanel().getActionMap();
        InputMap inputMap = buttonBarBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "enterOk");
        actionMap.put("enterOk", abstractAction);
        this.diag.pack();
        this.diag.setLocationRelativeTo(this.frame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StyleSelectDialog.this.contentPane.setDividerLocation(((StyleSelectDialog)StyleSelectDialog.this).contentPane.getSize().height - 150);
            }
        });
    }

    public void setVisible(boolean bl) {
        this.okPressed = false;
        this.diag.setVisible(bl);
    }

    private void readStyles() {
        this.table.clearSelection();
        this.styles.getReadWriteLock().writeLock().lock();
        this.styles.clear();
        if (this.styleDir.getText().length() > 0) {
            this.addStyles(this.styleDir.getText(), true);
        }
        this.styles.getReadWriteLock().writeLock().unlock();
        this.selectLastUsed();
    }

    private void selectLastUsed() {
        if (this.initSelection != null) {
            boolean bl = false;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((OOBibStyle)this.tableModel.getElementAt(i)).getFile().getPath().equals(this.initSelection)) continue;
                this.table.setRowSelectionInterval(i, i);
                bl = true;
                break;
            }
            if (!bl && this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void addStyles(String string, boolean bl) {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isDirectory() && file2.getName().endsWith(STYLE_FILE_EXTENSION)) {
                    this.addSingleFile(file2);
                    continue;
                }
                if (!file2.isDirectory() || !bl) continue;
                this.addStyles(file2.getPath(), bl);
            }
        } else {
            this.addSingleFile(file);
        }
    }

    private void addSingleFile(File file) {
        try {
            OOBibStyle oOBibStyle = new OOBibStyle(file);
            if (oOBibStyle.isValid() && !this.styles.contains(oOBibStyle)) {
                this.styles.add(oOBibStyle);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to read style file: '" + file.getPath() + "'");
            exception.printStackTrace();
        }
    }

    private void storeSettings() {
        OOBibStyle oOBibStyle = this.getSelectedStyle();
        Globals.prefs.putBoolean("ooUseDefaultAuthoryearStyle", this.useDefaultAuthoryear.isSelected());
        Globals.prefs.putBoolean("ooUseDefaultNumericalStyle", this.useDefaultNumerical.isSelected());
        Globals.prefs.putBoolean("ooChooseStyleDirectly", this.chooseDirectly.isSelected());
        Globals.prefs.put("ooDirectFile", this.directFile.getText());
        Globals.prefs.put("ooStyleDirectory", this.styleDir.getText());
        if (this.chooseDirectly.isSelected()) {
            Globals.prefs.put("ooBibliographyStyleFile", this.directFile.getText());
        } else if (this.setDirectory.isSelected() && oOBibStyle != null) {
            Globals.prefs.put("ooBibliographyStyleFile", oOBibStyle.getFile().getPath());
        }
    }

    private OOBibStyle getSelectedStyle() {
        if (this.selectionModel.getSelected().size() > 0) {
            return (OOBibStyle)this.selectionModel.getSelected().get(0);
        }
        return null;
    }

    private void setupPrevEntry() {
        this.prevEntry.setField("author", "Smith, Bill and Jones, Bob and Williams, Jeff");
        this.prevEntry.setField("editor", "Taylor, Phil");
        this.prevEntry.setField("title", "Title of the test entry for reference styles");
        this.prevEntry.setField("volume", "34");
        this.prevEntry.setField("year", "2008");
        this.prevEntry.setField("journal", "BibTeX journal");
        this.prevEntry.setField("publisher", "JabRef publishing");
        this.prevEntry.setField("address", "Trondheim");
        this.prevEntry.setField("www", "http://jabref.sf.net");
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void tablePopup(MouseEvent mouseEvent) {
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void displayDefaultStyle(boolean bl) {
        try {
            String string;
            URL uRL = bl ? JabRef.class.getResource("/resource/openoffice/default_authoryear.jstyle") : JabRef.class.getResource("/resource/openoffice/default_numerical.jstyle");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            final JDialog jDialog = new JDialog(this.diag, Globals.lang("Default style"), true);
            JLabel jLabel = new JLabel("<html>" + Globals.lang("The panel below shows the definition of the default style.") + Globals.lang("If you want to use it as a template for a new style, you can copy the contents into a new .jstyle file") + "</html>");
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jDialog.getContentPane().add((Component)jLabel, "North");
            JTextArea jTextArea = new JTextArea(stringBuilder.toString());
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setPreferredSize(new Dimension(700, 500));
            jDialog.getContentPane().add((Component)jScrollPane, "Center");
            JButton jButton = new JButton(Globals.lang("Ok"));
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addButton((JComponent)jButton);
            buttonBarBuilder.addGlue();
            buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jDialog.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.pack();
            jDialog.setLocationRelativeTo(this.diag);
            jDialog.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<OOBibStyle> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<OOBibStyle> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                OOBibStyle oOBibStyle = (OOBibStyle)listEvent.getSourceList().get(0);
                StyleSelectDialog.this.initSelection = oOBibStyle.getFile().getPath();
                StyleSelectDialog.this.preview.setLayout(oOBibStyle.getReferenceFormat("default"));
                StyleSelectDialog.this.contentPane.setDividerLocation(((StyleSelectDialog)StyleSelectDialog.this).contentPane.getSize().height - 150);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StyleSelectDialog.this.preview.update();
                        StyleSelectDialog.this.preview.scrollRectToVisible(StyleSelectDialog.this.toRect);
                    }
                });
            }
        }
    }

    static class StyleTableFormat
    implements TableFormat<OOBibStyle> {
        StyleTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Globals.lang("Name");
                }
                case 1: {
                    return Globals.lang("Journals");
                }
                case 2: {
                    return Globals.lang("File");
                }
            }
            return "";
        }

        @Override
        public Object getColumnValue(OOBibStyle oOBibStyle, int n) {
            switch (n) {
                case 0: {
                    return oOBibStyle.getName();
                }
                case 1: {
                    return this.formatJournals(oOBibStyle.getJournals());
                }
                case 2: {
                    return oOBibStyle.getFile().getName();
                }
            }
            return "";
        }

        private String formatJournals(Set<String> set) {
            StringBuilder stringBuilder = new StringBuilder("");
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }
}

