/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstaller;

class ManagePluginsDialog {
    private final JabRefFrame frame;
    private final JDialog diag;
    private SortedList<PluginInstaller.NameAndVersion> plugins;
    private final JTable table;
    private final JTable tableOther;

    public ManagePluginsDialog(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        this.diag = new JDialog(jabRefFrame, Globals.lang("Plugin manager"), false);
        JButton jButton = new JButton(Globals.lang("Help"));
        jButton.addActionListener(new HelpAction(Globals.helpDiag, "Plugin.html", "Help"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Globals.lang("Plugins installed in your user plugin directory (%0):", PluginCore.userPluginDir.getPath()));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        this.table = new JTable();
        this.tableOther = new JTable();
        this.tableOther.setRowSelectionAllowed(false);
        this.tableOther.setColumnSelectionAllowed(false);
        this.tableOther.setCellSelectionEnabled(false);
        this.buildList();
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.tableOther.setPreferredScrollableViewportSize(new Dimension(500, 100));
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        this.diag.getContentPane().add((Component)jPanel, "North");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jLabel = new JLabel(Globals.lang("Plugins installed in other locations:"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)new JScrollPane(this.tableOther), "Center");
        this.diag.getContentPane().add((Component)jPanel, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        JButton jButton2 = new JButton(Globals.lang("Install plugin"));
        buttonBarBuilder.addButton((JComponent)jButton2);
        JButton jButton3 = new JButton(Globals.lang("Download plugin"));
        buttonBarBuilder.addButton((JComponent)jButton3);
        JButton jButton4 = new JButton(Globals.lang("Delete"));
        buttonBarBuilder.addButton((JComponent)jButton4);
        JButton jButton5 = new JButton(Globals.lang("Close"));
        buttonBarBuilder.addButton((JComponent)jButton5);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        this.diag.setLocationRelativeTo(jabRefFrame);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePluginsDialog.this.installPlugin();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePluginsDialog.this.downloadPlugin();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePluginsDialog.this.diag.dispose();
            }
        };
        jButton5.addActionListener(abstractAction);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePluginsDialog.this.removeSelected();
            }
        });
        ActionMap actionMap = buttonBarBuilder.getPanel().getActionMap();
        InputMap inputMap = buttonBarBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
    }

    private void removeSelected() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 0) {
            int n;
            String string = Globals.lang("Delete the %0 selected plugins?", String.valueOf(nArray.length));
            String string2 = Globals.lang("Delete plugins");
            if (nArray.length == 1) {
                string = Globals.lang("Delete the selected plugin?");
                string2 = Globals.lang("Delete plugin");
            }
            if ((n = JOptionPane.showConfirmDialog(this.frame, string, string2, 0)) != 0) {
                return;
            }
            boolean bl = true;
            for (int n2 : nArray) {
                PluginInstaller.NameAndVersion nameAndVersion = (PluginInstaller.NameAndVersion)this.plugins.get(n2);
                bl = PluginInstaller.deletePlugin(nameAndVersion) & bl;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.frame, nArray.length > 1 ? Globals.lang("Plugins will be deleted next time JabRef starts up.") : Globals.lang("Plugin will be deleted next time JabRef starts up."), nArray.length > 1 ? Globals.lang("Delete plugins") : Globals.lang("Delete plugin"), 1);
            }
            this.buildList();
        }
    }

    private void buildList() {
        Object object;
        this.plugins = new SortedList<PluginInstaller.NameAndVersion>(PluginInstaller.findInstalledPlugins());
        BasicEventList<PluginInstaller.NameAndVersion> basicEventList = new BasicEventList<PluginInstaller.NameAndVersion>();
        Object object2 = this.plugins.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((PluginInstaller.NameAndVersion)object).inUserDirectory) continue;
            basicEventList.add((PluginInstaller.NameAndVersion)object);
            object2.remove();
        }
        object2 = new SortedList(basicEventList);
        object = new PluginTableFormat();
        EventTableModel eventTableModel = new EventTableModel(object2, object);
        this.tableOther.setModel(eventTableModel);
        this.tableOther.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tableOther.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.tableOther.getColumnModel().getColumn(2).setPreferredWidth(50);
        PluginTableFormat pluginTableFormat = new PluginTableFormat();
        EventTableModel<PluginInstaller.NameAndVersion> eventTableModel2 = new EventTableModel<PluginInstaller.NameAndVersion>(this.plugins, pluginTableFormat);
        this.table.setModel(eventTableModel2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
    }

    public void setVisible(boolean bl) {
        this.diag.setVisible(bl);
    }

    private void installPlugin() {
        String string = FileDialogs.getNewFile(this.frame, new File(System.getProperty("user.home")), ".jar", 0, false);
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ".", Globals.lang("Plugin installer"), 0);
        } else {
            this.installFromFile(file);
        }
    }

    private void downloadPlugin() {
        String string = JOptionPane.showInputDialog(Globals.lang("Enter download URL"));
        if (string == null) {
            return;
        }
        try {
            this.installFromURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL"), Globals.lang("Plugin installer"), 0);
        }
    }

    private void installFromURL(URL uRL) {
        try {
            File file = File.createTempFile("jabref-plugin", ".jar");
            file.deleteOnExit();
            URLDownload uRLDownload = URLDownload.buildMonitoredDownload(this.frame, uRL);
            uRLDownload.downloadToFile(file);
            String string = uRL.getPath();
            int n = string.lastIndexOf(47);
            if (n >= 0 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            PluginInstaller.installPlugin(this.frame, file, string);
            file.delete();
            this.buildList();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void installFromFile(File file) {
        PluginInstaller.installPlugin(this.frame, file, null);
        this.buildList();
    }

    private class PluginTableFormat
    implements TableFormat<PluginInstaller.NameAndVersion> {
        private PluginTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Globals.lang("Plugin name");
            }
            if (n == 1) {
                return Globals.lang("Version");
            }
            return Globals.lang("Status");
        }

        @Override
        public Object getColumnValue(PluginInstaller.NameAndVersion nameAndVersion, int n) {
            if (n == 0) {
                return nameAndVersion.name;
            }
            if (n == 1) {
                if (!nameAndVersion.version.equals(PluginInstaller.VersionNumber.ZERO)) {
                    return nameAndVersion.version.toString();
                }
                return Globals.lang("Unknown");
            }
            int n2 = nameAndVersion.getStatus();
            if (n2 == 0) {
                return Globals.lang("Not loaded");
            }
            if (n2 == 1) {
                return Globals.lang("Loaded");
            }
            return Globals.lang("Error");
        }
    }
}

