/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.plugin.PluginCore;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;

public class PluginInstaller {
    private static final String PLUGIN_XML_FILE = "plugin.xml";
    private static final int SUCCESS = 0;
    private static final int UNABLE_TO_CREATE_DIR = 1;
    private static final int UNABLE_TO_COPY_FILE = 2;
    private static final int NO_VERSIONS_INSTALLED = 0;
    private static final int NEWER_VERSION_INSTALLED = 1;
    private static final int SAME_VERSION_INSTALLED = 2;
    private static final int OLDER_VERSION_INSTALLED = 3;
    public static final int UNCONVENTIONAL_FILENAME = 4;
    private static final int UNKNOWN_VERSION = 5;
    public static final int NOT_LOADED = 0;
    private static final int LOADED = 1;
    private static final int BAD = 2;
    static Pattern pluginFilePattern = Pattern.compile("(.*)-([\\d\\.]+).jar");
    static Pattern pluginFilePatternNoVersion = Pattern.compile("(.*).jar");

    public static void installPlugin(JabRefFrame jabRefFrame, File file, String string) {
        int n;
        String string2;
        String string3 = string2 = string != null ? string : file.getName();
        if (!PluginCore.userPluginDir.exists() && (n = PluginCore.userPluginDir.mkdirs()) == 0) {
            JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Unable to create plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").", Globals.lang("Plugin installer"), 0);
            return;
        }
        n = PluginInstaller.checkInstalledVersion(file);
        switch (n) {
            case 0: {
                int n2 = PluginInstaller.copyPlugin((JFrame)jabRefFrame, file, string2);
                if (n2 == 0) {
                    JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Plugin installed successfully. You must restart JabRef to load the new plugin."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String string4 = n2 == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Plugin installation failed.") + " " + string4, Globals.lang("Plugin installer"), 0);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("The same version of this plugin is already installed."), Globals.lang("Plugin installer"), 1);
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("A newer version of this plugin is already installed."), Globals.lang("Plugin installer"), 1);
                break;
            }
            case 3: {
                int n3 = PluginInstaller.copyPlugin((JFrame)jabRefFrame, file, string2);
                if (n3 == 0) {
                    int n4 = JOptionPane.showConfirmDialog(jabRefFrame, Globals.lang("One or more older versions of this plugin is installed. Delete old versions?"), Globals.lang("Plugin installer"), 0);
                    if (n4 != 0) break;
                    boolean bl = PluginInstaller.deleteOlderVersions(file);
                    if (bl) {
                        JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Old versions deleted successfully."), Globals.lang("Plugin installer"), 1);
                        break;
                    }
                    JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Old plugin versions will be deleted next time JabRef starts up."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String string5 = n3 == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Plugin installation failed.") + " " + string5, Globals.lang("Plugin installer"), 0);
                break;
            }
            case 5: {
                JLabel jLabel = new JLabel("<html>" + Globals.lang("Unable to determine plugin name and version. This may not be a valid JabRef plugin.") + "<br>" + Globals.lang("Install anyway?") + "</html>");
                int n5 = JOptionPane.showConfirmDialog(jabRefFrame, jLabel, Globals.lang("Plugin installer"), 0);
                if (n5 != 0) break;
                int n6 = PluginInstaller.copyPlugin((JFrame)jabRefFrame, file, string2);
                if (n6 == 0) {
                    JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Plugin installed successfully. You must restart JabRef to load the new plugin."), Globals.lang("Plugin installer"), 1);
                    break;
                }
                String string6 = n6 == 2 ? Globals.lang("Unable to copy file") : Globals.lang("Unable to create user plugin directory") + " (" + PluginCore.userPluginDir.getPath() + ").";
                JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Plugin installation failed.") + " " + string6, Globals.lang("Plugin installer"), 0);
            }
        }
    }

    private static int checkInstalledVersion(File file) {
        boolean bl;
        String[] stringArray = PluginInstaller.getNameAndVersion(file);
        if (stringArray == null) {
            return 5;
        }
        VersionNumber versionNumber = new VersionNumber(stringArray[1]);
        Map<VersionNumber, File> map = PluginInstaller.getInstalledVersions(stringArray[0]);
        if (map.size() == 0) {
            return 0;
        }
        VersionNumber versionNumber2 = map.keySet().iterator().next();
        boolean bl2 = versionNumber.compareTo(versionNumber2) == 0;
        boolean bl3 = bl = versionNumber.compareTo(versionNumber2) > 0;
        if (bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        return 3;
    }

    public static boolean deletePlugin(NameAndVersion nameAndVersion) {
        return PluginInstaller.deletePluginFile(nameAndVersion.file);
    }

    private static boolean deleteOlderVersions(File file) {
        String[] stringArray = PluginInstaller.getNameAndVersion(file);
        if (stringArray == null) {
            return false;
        }
        boolean bl = true;
        VersionNumber versionNumber = new VersionNumber(stringArray[1]);
        Map<VersionNumber, File> map = PluginInstaller.getInstalledVersions(stringArray[0]);
        for (VersionNumber versionNumber2 : map.keySet()) {
            if (versionNumber.compareTo(versionNumber2) >= 0) continue;
            String string = versionNumber2.equals(VersionNumber.ZERO) ? null : versionNumber2.toString();
            File file2 = map.get(versionNumber2);
            bl = PluginInstaller.deletePluginFile(file2);
        }
        return bl;
    }

    private static boolean deletePluginFile(File file) {
        boolean bl = file.delete();
        if (bl) {
            return true;
        }
        PluginInstaller.schedulePluginForDeletion(file.getPath());
        return false;
    }

    public static int copyPlugin(JFrame jFrame, URL uRL, String string) {
        boolean bl;
        if (string == null) {
            string = uRL.getFile();
        }
        if (!PluginCore.userPluginDir.exists() && !(bl = PluginCore.userPluginDir.mkdirs())) {
            return 1;
        }
        File file = new File(PluginCore.userPluginDir, string);
        URLDownload uRLDownload = URLDownload.buildMonitoredDownload(jFrame, uRL);
        try {
            uRLDownload.downloadToFile(file);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copyPlugin(JFrame jFrame, File file, String string) {
        boolean bl;
        if (string == null) {
            string = file.getName();
        }
        if (!PluginCore.userPluginDir.exists() && !(bl = PluginCore.userPluginDir.mkdirs())) {
            return 1;
        }
        File file2 = new File(PluginCore.userPluginDir, string);
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int n = 2;
            return n;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    private static Map<VersionNumber, File> getInstalledVersions(String string) {
        String[] stringArray = PluginCore.userPluginDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        });
        TreeMap<VersionNumber, File> treeMap = new TreeMap<VersionNumber, File>();
        for (String string2 : stringArray) {
            File file = new File(PluginCore.userPluginDir, string2);
            String[] stringArray2 = PluginInstaller.getNameAndVersion(file);
            if (stringArray2 == null || !stringArray2[0].equals(string)) continue;
            VersionNumber versionNumber = new VersionNumber(stringArray2[1]);
            treeMap.put(versionNumber, file);
        }
        return treeMap;
    }

    private static void schedulePluginForDeletion(String string) {
        String[] stringArray;
        String[] stringArray2 = Globals.prefs.getStringArray("deletePlugins");
        String[] stringArray3 = stringArray = stringArray2 == null ? new String[1] : new String[stringArray2.length + 1];
        if (stringArray2 != null) {
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        }
        stringArray[stringArray.length - 1] = string;
        Globals.prefs.putStringArray("deletePlugins", stringArray);
    }

    public static void deletePluginsOnStartup(String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            if (file.getParentFile().equals(PluginCore.userPluginDir)) {
                boolean bl = file.delete();
                continue;
            }
            System.out.println("File outside of user plugin dir: " + string);
        }
    }

    private static String[] getNameAndVersion(File file) {
        try {
            File file2 = PluginInstaller.unpackPluginXML(file);
            if (file2 == null) {
                return null;
            }
            ManifestInfo manifestInfo = PluginCore.getManager().getRegistry().readManifestInfo(file2.toURI().toURL());
            file2.delete();
            return new String[]{manifestInfo.getId(), manifestInfo.getVersion().toString()};
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (ManifestProcessingException manifestProcessingException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File unpackPluginXML(File file) {
        ZipEntry zipEntry;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            JarFile jarFile = new JarFile(file);
            zipEntry = jarFile.getEntry(PLUGIN_XML_FILE);
            if (zipEntry == null) {
                File file2 = null;
                return file2;
            }
            File file3 = File.createTempFile("jabref_plugin", ".xml");
            file3.deleteOnExit();
            inputStream = new BufferedInputStream(jarFile.getInputStream(zipEntry));
            outputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            File file4 = file3;
            return file4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            zipEntry = null;
            return zipEntry;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static EventList<NameAndVersion> findInstalledPlugins() {
        Comparable<File> comparable;
        BasicEventList<NameAndVersion> basicEventList = new BasicEventList<NameAndVersion>();
        if (!PluginCore.userPluginDir.exists()) {
            return basicEventList;
        }
        String[] stringArray = PluginCore.userPluginDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        });
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        Collection<PluginDescriptor> collection = PluginCore.getManager().getRegistry().getPluginDescriptors();
        for (PluginDescriptor pluginDescriptor : collection) {
            if (pluginDescriptor.getPluginClassName() != null && pluginDescriptor.getPluginClassName().equals("net.sf.jabref.plugin.core.JabRefPlugin")) continue;
            hashMap.put(pluginDescriptor.getId(), pluginDescriptor);
        }
        for (String object : stringArray) {
            comparable = new File(PluginCore.userPluginDir, object);
            String[] stringArray2 = PluginInstaller.getNameAndVersion((File)comparable);
            if (stringArray2 == null) continue;
            VersionNumber versionNumber = stringArray2[1] != null ? new VersionNumber(stringArray2[1]) : null;
            NameAndVersion nameAndVersion = new NameAndVersion(stringArray2[0], versionNumber, true, (File)comparable);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.contains(stringArray2[0])) continue;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)hashMap.get(string);
                if (!PluginCore.getManager().isPluginEnabled((PluginDescriptor)hashMap.get(string))) {
                    nameAndVersion.setStatus(2);
                } else {
                    nameAndVersion.setStatus(1);
                }
                iterator.remove();
            }
            basicEventList.add(nameAndVersion);
        }
        for (String string : hashMap.keySet()) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)hashMap.get(string);
            File file = new File(pluginDescriptor.getLocation().getFile());
            if (file.getPath().contains(PluginCore.userPluginDir.getPath())) continue;
            comparable = new NameAndVersion(pluginDescriptor.getId(), new VersionNumber(pluginDescriptor.getVersion().toString()), false, file);
            if (!PluginCore.getManager().isPluginEnabled((PluginDescriptor)hashMap.get(string))) {
                ((NameAndVersion)comparable).setStatus(2);
            } else {
                ((NameAndVersion)comparable).setStatus(1);
            }
            basicEventList.add((NameAndVersion)comparable);
        }
        return basicEventList;
    }

    static class VersionNumber
    implements Comparable<VersionNumber> {
        public static final VersionNumber ZERO = new VersionNumber("0");
        final List<Integer> digits = new ArrayList<Integer>();

        public VersionNumber(String string) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\.")) {
                try {
                    int n = Integer.parseInt(string2);
                    this.digits.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int compareTo(VersionNumber versionNumber) {
            for (int i = 0; i < Math.min(this.digits.size(), versionNumber.digits.size()); ++i) {
                if (this.digits.get(i).equals(versionNumber.digits.get(i))) continue;
                return versionNumber.digits.get(i) - this.digits.get(i);
            }
            return versionNumber.digits.size() - this.digits.size();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Integer> iterator = this.digits.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(".");
            }
            return stringBuilder.toString();
        }

        public boolean equals(VersionNumber versionNumber) {
            return this.compareTo(versionNumber) == 0;
        }
    }

    public static class NameAndVersion
    implements Comparable<NameAndVersion> {
        final String name;
        final VersionNumber version;
        int status = 0;
        final boolean inUserDirectory;
        final File file;

        public NameAndVersion(String string, VersionNumber versionNumber, boolean bl, File file) {
            this.name = string;
            this.version = versionNumber;
            this.inUserDirectory = bl;
            this.file = file;
        }

        @Override
        public int compareTo(NameAndVersion nameAndVersion) {
            if (!this.name.equals(nameAndVersion.name)) {
                return this.name.compareTo(nameAndVersion.name);
            }
            if (this.version == null) {
                return 1;
            }
            if (nameAndVersion.version == null) {
                return -1;
            }
            return this.version.compareTo(nameAndVersion.version);
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int n) {
            this.status = n;
        }
    }
}

