/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.remote.client;

import java.net.InetAddress;
import java.net.Socket;
import net.sf.jabref.Globals;
import net.sf.jabref.remote.shared.Protocol;
import net.sf.jabref.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteListenerClient {
    private static final Log LOGGER = LogFactory.getLog(RemoteListenerClient.class);
    private static final int TWO_SECONDS_TIMEOUT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sendToActiveJabRefInstance(String[] stringArray, int n) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            Socket socket = new Socket(inetAddress, n);
            socket.setSoTimeout(2000);
            Protocol protocol = new Protocol(socket);
            try {
                String string = protocol.receiveMessage();
                if (!"jabref".equals(string)) {
                    String string2 = String.valueOf(n);
                    String string3 = Globals.lang("Cannot use port %0 for remote operation; another application may be using it. Try specifying another port.", string2);
                    System.out.println(string3);
                    boolean bl = false;
                    return bl;
                }
                protocol.sendMessage(StringUtil.join(stringArray, "\n"));
                boolean bl = true;
                return bl;
            }
            finally {
                protocol.close();
            }
        }
        catch (Exception exception) {
            LOGGER.debug("could not send args " + StringUtil.join(stringArray, ", ") + " to the server at port " + n, exception);
            return false;
        }
    }
}

