/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.remote.shared;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class Protocol {
    public static final String IDENTIFIER = "jabref";
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;

    public Protocol(Socket socket) throws IOException {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
    }

    public void sendMessage(String string) throws IOException {
        this.out.write(string.getBytes());
        this.out.write(0);
        this.out.flush();
    }

    public String receiveMessage() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = this.in.read()) != 0 && n >= 0) {
                stringBuilder.append((char)n);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("Connection timed out.");
        }
        return stringBuilder.toString();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

