/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search.describer;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import net.sf.jabref.Globals;
import net.sf.jabref.search.SearchBaseVisitor;
import net.sf.jabref.search.SearchParser;
import net.sf.jabref.search.describer.SearchDescriber;
import net.sf.jabref.search.rules.GrammarBasedSearchRule;
import net.sf.jabref.util.StringUtil;
import org.antlr.v4.runtime.tree.ParseTree;

public class GrammarBasedSearchRuleDescriber
implements SearchDescriber {
    private final boolean caseSensitive;
    private final boolean regExp;
    private final ParseTree parseTree;

    public GrammarBasedSearchRuleDescriber(boolean bl, boolean bl2, ParseTree parseTree) {
        this.caseSensitive = bl;
        this.regExp = bl2;
        this.parseTree = Preconditions.checkNotNull(parseTree);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Globals.lang("This group contains entries in which")).append(' ');
        stringBuilder.append((String)new SearchBaseVisitor<String>(){

            @Override
            public String visitStart(SearchParser.StartContext startContext) {
                return (String)this.visit(startContext.expression());
            }

            @Override
            public String visitUnaryExpression(SearchParser.UnaryExpressionContext unaryExpressionContext) {
                return String.format("%s %s", Globals.lang("not"), this.visit(unaryExpressionContext.expression()));
            }

            @Override
            public String visitParenExpression(SearchParser.ParenExpressionContext parenExpressionContext) {
                return String.format("%s", parenExpressionContext.expression());
            }

            @Override
            public String visitBinaryExpression(SearchParser.BinaryExpressionContext binaryExpressionContext) {
                if (binaryExpressionContext.operator.getText().equalsIgnoreCase("AND")) {
                    return String.format("(%s %s %s)", this.visit(binaryExpressionContext.left), Globals.lang("and"), this.visit(binaryExpressionContext.right));
                }
                return String.format("(%s %s %s)", this.visit(binaryExpressionContext.left), Globals.lang("or"), this.visit(binaryExpressionContext.right));
            }

            @Override
            public String visitComparison(SearchParser.ComparisonContext comparisonContext) {
                String string;
                String string2 = StringUtil.unquote(comparisonContext.left.getText(), '\"');
                String string3 = StringUtil.unquote(comparisonContext.right.getText(), '\"');
                GrammarBasedSearchRule.ComparisonOperator comparisonOperator = GrammarBasedSearchRule.ComparisonOperator.build(comparisonContext.operator.getText());
                boolean bl = !Pattern.matches("\\w+", string2);
                String string4 = StringUtil.quoteForHTML(string3);
                String string5 = string = bl ? Globals.lang("any field that matches the regular expression <b>%0</b>", StringUtil.quoteForHTML(string2)) : Globals.lang("the field <b>%0</b>", StringUtil.quoteForHTML(string2));
                if (comparisonOperator == GrammarBasedSearchRule.ComparisonOperator.CONTAINS) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Globals.lang("%0 contains the Regular Expression <b>%1</b>", string, string4);
                    }
                    return Globals.lang("%0 contains the term <b>%1</b>", string, string4);
                }
                if (comparisonOperator == GrammarBasedSearchRule.ComparisonOperator.EXACT) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Globals.lang("%0 matches the Regular Expression <b>%1</b>", string, string4);
                    }
                    return Globals.lang("%0 matches the term <b>%1</b>", string, string4);
                }
                if (comparisonOperator == GrammarBasedSearchRule.ComparisonOperator.DOES_NOT_CONTAIN) {
                    if (GrammarBasedSearchRuleDescriber.this.regExp) {
                        return Globals.lang("%0 doesn't contain the Regular Expression <b>%1</b>", string, string4);
                    }
                    return Globals.lang("%0 doesn't contain the term <b>%1</b>", string, string4);
                }
                throw new IllegalStateException("CANNOT HAPPEN!");
            }
        }.visit(this.parseTree));
        stringBuilder.append(". ");
        stringBuilder.append(this.caseSensitive ? Globals.lang("The search is case sensitive.") : Globals.lang("The search is case insensitive."));
        return stringBuilder.toString();
    }
}

