/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search.describer;

import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.describer.ContainsAndRegexBasedSearchRuleDescriber;
import net.sf.jabref.search.describer.GrammarBasedSearchRuleDescriber;
import net.sf.jabref.search.describer.SearchDescriber;
import net.sf.jabref.search.rules.ContainBasedSearchRule;
import net.sf.jabref.search.rules.GrammarBasedSearchRule;
import net.sf.jabref.search.rules.RegexBasedSearchRule;

public class SearchDescribers {
    public static SearchDescriber getSearchDescriberFor(SearchRule searchRule, String string) {
        if (searchRule instanceof GrammarBasedSearchRule) {
            GrammarBasedSearchRule grammarBasedSearchRule = (GrammarBasedSearchRule)searchRule;
            return new GrammarBasedSearchRuleDescriber(grammarBasedSearchRule.isCaseSensitiveSearch(), grammarBasedSearchRule.isRegExpSearch(), grammarBasedSearchRule.getTree());
        }
        if (searchRule instanceof ContainBasedSearchRule) {
            ContainBasedSearchRule containBasedSearchRule = (ContainBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(containBasedSearchRule.isCaseSensitive(), false, string);
        }
        if (searchRule instanceof RegexBasedSearchRule) {
            RegexBasedSearchRule regexBasedSearchRule = (RegexBasedSearchRule)searchRule;
            return new ContainsAndRegexBasedSearchRuleDescriber(regexBasedSearchRule.isCaseSensitive(), true, string);
        }
        throw new IllegalStateException("Cannot find a describer for searchRule " + searchRule + " and query " + string);
    }
}

