/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.search.SearchBaseVisitor;
import net.sf.jabref.search.SearchLexer;
import net.sf.jabref.search.SearchParser;
import net.sf.jabref.search.SearchRule;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class GrammarBasedSearchRule
implements SearchRule {
    private final boolean caseSensitiveSearch;
    private final boolean regExpSearch;
    private ParseTree tree;
    private String query;

    public GrammarBasedSearchRule(boolean bl, boolean bl2) throws RecognitionException {
        this.caseSensitiveSearch = bl;
        this.regExpSearch = bl2;
    }

    public static boolean isValid(boolean bl, boolean bl2, String string) {
        return new GrammarBasedSearchRule(bl, bl2).validateSearchStrings(string);
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public boolean isRegExpSearch() {
        return this.regExpSearch;
    }

    public ParseTree getTree() {
        return this.tree;
    }

    public String getQuery() {
        return this.query;
    }

    private void init(String string) throws ParseCancellationException {
        if (this.query != null && this.query.equals(string)) {
            return;
        }
        SearchLexer searchLexer = new SearchLexer(new ANTLRInputStream(string));
        searchLexer.removeErrorListeners();
        searchLexer.addErrorListener(ThrowingErrorListener.INSTANCE);
        SearchParser searchParser = new SearchParser(new CommonTokenStream(searchLexer));
        searchParser.removeErrorListeners();
        searchParser.addErrorListener(ThrowingErrorListener.INSTANCE);
        searchParser.setErrorHandler(new BailErrorStrategy());
        this.tree = searchParser.start();
        this.query = string;
    }

    @Override
    public boolean applyRule(String string, BibtexEntry bibtexEntry) {
        return (Boolean)new BibtexSearchVisitor(this.caseSensitiveSearch, this.regExpSearch, bibtexEntry).visit(this.tree);
    }

    @Override
    public boolean validateSearchStrings(String string) {
        try {
            this.init(string);
            return true;
        }
        catch (ParseCancellationException parseCancellationException) {
            return false;
        }
    }

    static class BibtexSearchVisitor
    extends SearchBaseVisitor<Boolean> {
        private final boolean caseSensitive;
        private final boolean regex;
        private final BibtexEntry entry;

        public BibtexSearchVisitor(boolean bl, boolean bl2, BibtexEntry bibtexEntry) {
            this.caseSensitive = bl;
            this.regex = bl2;
            this.entry = bibtexEntry;
        }

        public boolean comparison(String string, ComparisonOperator comparisonOperator, String string2) {
            return new Comparator(string, string2, comparisonOperator, this.caseSensitive, this.regex).compare(this.entry);
        }

        @Override
        public Boolean visitStart(SearchParser.StartContext startContext) {
            return (Boolean)this.visit(startContext.expression());
        }

        @Override
        public Boolean visitComparison(SearchParser.ComparisonContext comparisonContext) {
            return this.comparison(comparisonContext.left.getText(), ComparisonOperator.build(comparisonContext.operator.getText()), comparisonContext.right.getText());
        }

        @Override
        public Boolean visitUnaryExpression(SearchParser.UnaryExpressionContext unaryExpressionContext) {
            return (Boolean)this.visit(unaryExpressionContext.expression()) == false;
        }

        @Override
        public Boolean visitParenExpression(SearchParser.ParenExpressionContext parenExpressionContext) {
            return (Boolean)this.visit(parenExpressionContext.expression());
        }

        @Override
        public Boolean visitBinaryExpression(SearchParser.BinaryExpressionContext binaryExpressionContext) {
            if (binaryExpressionContext.operator.getText().equalsIgnoreCase("AND")) {
                return (Boolean)this.visit(binaryExpressionContext.left) != false && (Boolean)this.visit(binaryExpressionContext.right) != false;
            }
            return (Boolean)this.visit(binaryExpressionContext.left) != false || (Boolean)this.visit(binaryExpressionContext.right) != false;
        }
    }

    public static class Comparator {
        private final ComparisonOperator operator;
        private final Pattern fieldPattern;
        private final Pattern valuePattern;

        public Comparator(String string, String string2, ComparisonOperator comparisonOperator, boolean bl, boolean bl2) {
            this.operator = comparisonOperator;
            this.fieldPattern = Pattern.compile(bl2 ? string : "\\Q" + string + "\\E", bl ? 0 : 2);
            this.valuePattern = Pattern.compile(bl2 ? string2 : "\\Q" + string2 + "\\E", bl ? 0 : 2);
        }

        public boolean compare(BibtexEntry bibtexEntry) {
            String[] stringArray = bibtexEntry.getAllFields().toArray(new String[bibtexEntry.getAllFields().size()]);
            boolean bl = true;
            for (int i = 0; i < stringArray.length + 1; ++i) {
                String string;
                if (i - stringArray.length == 0) {
                    if (!this.fieldPattern.matcher("entrytype").matches()) continue;
                    string = bibtexEntry.getType().getName();
                } else {
                    String string2 = stringArray[i];
                    if (!this.fieldPattern.matcher(string2).matches()) continue;
                    string = bibtexEntry.getField(string2);
                }
                bl = false;
                if (string == null || !this.matchInField(string)) continue;
                return true;
            }
            return bl && this.operator == ComparisonOperator.DOES_NOT_CONTAIN;
        }

        public boolean matchInField(String string) {
            Matcher matcher = this.valuePattern.matcher(string);
            if (this.operator == ComparisonOperator.CONTAINS) {
                return matcher.find();
            }
            if (this.operator == ComparisonOperator.EXACT) {
                return matcher.matches();
            }
            if (this.operator == ComparisonOperator.DOES_NOT_CONTAIN) {
                return !matcher.find();
            }
            throw new IllegalStateException("MUST NOT HAPPEN");
        }
    }

    public static enum ComparisonOperator {
        EXACT,
        CONTAINS,
        DOES_NOT_CONTAIN;


        public static ComparisonOperator build(String string) {
            if (string.equalsIgnoreCase("CONTAINS") || string.equals("=")) {
                return CONTAINS;
            }
            if (string.equalsIgnoreCase("MATCHES") || string.equals("==")) {
                return EXACT;
            }
            return DOES_NOT_CONTAIN;
        }
    }

    public static class ThrowingErrorListener
    extends BaseErrorListener {
        public static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object object, int n, int n2, String string, RecognitionException recognitionException) throws ParseCancellationException {
            throw new ParseCancellationException("line " + n + ":" + n2 + " " + string);
        }
    }
}

