/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.rules.util.SentenceAnalyzer;

public class RegexBasedSearchRule
implements SearchRule {
    private static final RemoveLatexCommands REMOVE_LATEX_COMMANDS = new RemoveLatexCommands();
    private final boolean caseSensitive;

    public RegexBasedSearchRule(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean validateSearchStrings(String string) {
        String string2 = string;
        if (!this.caseSensitive) {
            string2 = string2.toLowerCase();
        }
        List<String> list = new SentenceAnalyzer(string2).getWords();
        try {
            for (String string3 : list) {
                Pattern.compile(string3, this.caseSensitive ? 0 : 2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean applyRule(String string, BibtexEntry bibtexEntry) {
        String string2 = string;
        if (!this.caseSensitive) {
            string2 = string2.toLowerCase();
        }
        List<String> list = new SentenceAnalyzer(string2).getWords();
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        try {
            for (String object : list) {
                arrayList.add(Pattern.compile(object, this.caseSensitive ? 0 : 2));
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        Object object = new boolean[list.size()];
        for (String string3 : bibtexEntry.getAllFields()) {
            String string4 = bibtexEntry.getField(string3);
            if (string4 == null) continue;
            String object2 = REMOVE_LATEX_COMMANDS.format(string4.toString());
            if (!this.caseSensitive) {
                object2 = object2.toLowerCase();
            }
            int n = 0;
            for (Pattern pattern : arrayList) {
                String string5 = REMOVE_LATEX_COMMANDS.format(object2);
                Matcher matcher = pattern.matcher(string5);
                object[n] = object[n] != false || matcher.find();
                ++n;
            }
        }
        for (Object object2 : object) {
            if (object2 != false) continue;
            return false;
        }
        return true;
    }
}

