/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.sql.DBStrings;

public class SQLUtil {
    private static final ArrayList<String> reservedDBWords = new ArrayList<String>(Collections.singletonList("key"));
    private static ArrayList<String> allFields = null;

    private SQLUtil() {
    }

    private static void refreshFields() {
        if (allFields == null) {
            allFields = new ArrayList();
        } else {
            allFields.clear();
        }
        SQLUtil.uniqueInsert(allFields, BibtexFields.getAllFieldNames());
        SQLUtil.uniqueInsert(allFields, BibtexFields.getAllPrivateFieldNames());
    }

    public static ArrayList<String> getAllFields() {
        if (allFields == null) {
            SQLUtil.refreshFields();
        }
        return allFields;
    }

    public static String getFieldStr() {
        String string = "";
        for (int i = 0; i < SQLUtil.getAllFields().size(); ++i) {
            String string2 = allFields.get(i);
            if (i > 0) {
                string = string + ", ";
            }
            if (reservedDBWords.contains(string2)) {
                string2 = string2 + "_";
            }
            string = string + string2;
        }
        return string;
    }

    private static ArrayList<String> uniqueInsert(ArrayList<String> arrayList, String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (arrayList.contains(string) || string.equals("#")) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String fieldsAsCols(ArrayList<String> arrayList, String string) {
        String string2 = "";
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string3 = listIterator.next();
            if (reservedDBWords.contains(string3)) {
                string3 = string3 + '_';
            }
            string2 = string2 + string3 + string;
            if (!listIterator.hasNext()) continue;
            string2 = string2 + ", ";
        }
        return string2;
    }

    public static ArrayList<String> setFieldRequirement(ArrayList<String> arrayList, List<String> list, List<String> list2, List<String> list3, ArrayList<String> arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (list.contains(string)) {
                arrayList2.set(i, "req");
                continue;
            }
            if (list2.contains(string)) {
                arrayList2.set(i, "opt");
                continue;
            }
            if (!list3.contains(string)) continue;
            arrayList2.set(i, "uti");
        }
        return arrayList2;
    }

    public static String getExceptionMessage(Exception exception) {
        String string = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        return string;
    }

    public static ResultSet queryAllFromTable(Connection connection, String string) throws SQLException {
        String string2 = "SELECT * FROM " + string + ';';
        Statement statement = (Statement)SQLUtil.processQueryWithResults(connection, string2);
        return statement.getResultSet();
    }

    public static void processQuery(Object object, String string) throws SQLException {
        AutoCloseable autoCloseable;
        if (object instanceof PrintStream) {
            autoCloseable = (PrintStream)object;
            autoCloseable.println(string);
        }
        if (object instanceof Connection) {
            autoCloseable = (Connection)object;
            SQLUtil.executeQuery((Connection)autoCloseable, string);
        }
    }

    public static Object processQueryWithResults(Object object, String string) throws SQLException {
        if (object instanceof PrintStream) {
            PrintStream printStream = (PrintStream)object;
            printStream.println(string);
            return printStream;
        }
        if (object instanceof Connection) {
            Connection connection = (Connection)object;
            return SQLUtil.executeQueryWithResults(connection, string);
        }
        return null;
    }

    public static String createJDBCurl(DBStrings dBStrings, boolean bl) {
        String string = "jdbc:" + dBStrings.getServerType().toLowerCase() + "://" + dBStrings.getServerHostname() + (bl ? '/' + dBStrings.getDatabase() : "");
        return string;
    }

    public static String processQueryWithSingleResult(Connection connection, String string) throws SQLException {
        ResultSet resultSet = SQLUtil.executeQueryWithResults(connection, string).getResultSet();
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.getStatement().close();
        return string2;
    }

    private static void executeQuery(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute(string);
        SQLWarning sQLWarning = statement.getWarnings();
        if (sQLWarning != null) {
            System.err.println(sQLWarning.toString());
        }
        statement.close();
    }

    private static Statement executeQueryWithResults(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeQuery(string);
        SQLWarning sQLWarning = statement.getWarnings();
        if (sQLWarning != null) {
            System.err.println(sQLWarning.toString());
        }
        return statement;
    }
}

