/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBExporterAndImporterFactory;
import net.sf.jabref.sql.DBImportExportDialog;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.importer.DBImporter;
import net.sf.jabref.util.Util;

public class DbImportAction
extends AbstractWorker {
    private BibtexDatabase database = null;
    private MetaData metaData = null;
    private boolean connectToDB = false;
    private final JabRefFrame frame;
    private DBStrings dbs = null;
    private ArrayList<Object[]> databases = null;

    public DbImportAction(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
    }

    public AbstractAction getAction() {
        return new DbImpAction();
    }

    @Override
    public void init() {
        this.dbs = new DBStrings();
        this.dbs.initialize();
        DBConnectDialog dBConnectDialog = new DBConnectDialog(this.frame, this.dbs);
        this.dbs = dBConnectDialog.getDBStrings();
        if (!this.dbs.isConfigValid()) {
            if (!this.dbs.isInitialized()) {
                this.dbs.initialize();
            }
            dBConnectDialog = new DBConnectDialog(this.frame, this.dbs);
            Util.placeDialog(dBConnectDialog, this.frame);
            dBConnectDialog.setVisible(true);
            this.connectToDB = dBConnectDialog.getConnectToDB();
            if (this.connectToDB) {
                this.dbs = dBConnectDialog.getDBStrings();
                dBConnectDialog.dispose();
            }
        } else {
            this.connectToDB = true;
        }
    }

    @Override
    public void run() {
        this.performImport();
    }

    private void performImport() {
        if (this.connectToDB) {
            try {
                this.frame.output(Globals.lang("Attempting SQL import..."));
                DBExporterAndImporterFactory dBExporterAndImporterFactory = new DBExporterAndImporterFactory();
                DBImporter dBImporter = dBExporterAndImporterFactory.getImporter(this.dbs.getServerType());
                Connection connection = dBImporter.connectToDB(this.dbs);
                ResultSet resultSet = SQLUtil.queryAllFromTable(connection, "jabref_database");
                Vector<Vector<String>> vector = new Vector<Vector<String>>();
                while (resultSet.next()) {
                    Vector<String> vector2 = new Vector<String>();
                    vector2.add(resultSet.getString("database_name"));
                    vector.add(vector2);
                }
                if (!vector.isEmpty()) {
                    DBImportExportDialog dBImportExportDialog = new DBImportExportDialog(this.frame, vector, DBImportExportDialog.DialogType.IMPORTER);
                    if (dBImportExportDialog.removeAction) {
                        String string = dBImportExportDialog.selectedDB;
                        dBImporter.removeDB(dBImportExportDialog, string, connection, this.metaData);
                        this.performImport();
                    } else if (dBImportExportDialog.moreThanOne) {
                        this.databases = dBImporter.performImport(null, this.dbs, dBImportExportDialog.listOfDBs);
                        for (Object[] objectArray : this.databases) {
                            this.database = (BibtexDatabase)objectArray[0];
                            this.metaData = (MetaData)objectArray[1];
                            this.dbs.isConfigValid(true);
                        }
                        this.frame.output(Globals.lang("%0 databases will be imported", Integer.toString(this.databases.size())));
                    } else {
                        this.frame.output(Globals.lang("Importing cancelled"));
                    }
                } else {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("There are no available databases to be imported"), Globals.lang("Import from SQL database"), 1);
                }
            }
            catch (Exception exception) {
                String string = "Could not import from SQL database for the following reason:";
                String string2 = SQLUtil.getExceptionMessage(exception);
                this.dbs.isConfigValid(false);
                JOptionPane.showMessageDialog(this.frame, Globals.lang(string) + '\n' + string2, Globals.lang("Import from SQL database"), 0);
                this.frame.output(Globals.lang("Error importing from database"));
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void update() {
        if (this.databases == null) {
            return;
        }
        for (Object[] objectArray : this.databases) {
            this.database = (BibtexDatabase)objectArray[0];
            this.metaData = (MetaData)objectArray[1];
            if (this.database == null) continue;
            BasePanel basePanel = this.frame.addTab(this.database, null, this.metaData, Globals.prefs.get("defaultEncoding"), true);
            basePanel.metaData().setDBStrings(this.dbs);
            this.frame.setTabTitle(basePanel, objectArray[2] + "(Imported)", "Imported DB");
            basePanel.markBaseChanged();
        }
        this.frame.output(Globals.lang("Imported %0 databases successfully", Integer.toString(this.databases.size())));
    }

    class DbImpAction
    extends MnemonicAwareAction {
        public DbImpAction() {
            super(GUIGlobals.getImage("dbImport"));
            this.putValue("Name", "Import from external SQL database");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Util.runAbstractWorker(DbImportAction.this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

