/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.importer.DBImporter;

public class PostgreSQLImporter
extends DBImporter {
    private static PostgreSQLImporter instance = null;

    private PostgreSQLImporter() {
    }

    public static PostgreSQLImporter getInstance() {
        if (instance == null) {
            instance = new PostgreSQLImporter();
        }
        return instance;
    }

    @Override
    protected ResultSet readColumnNames(Connection connection) throws SQLException {
        Statement statement = (Statement)SQLUtil.processQueryWithResults(connection, "SELECT column_name FROM information_schema.columns WHERE table_name ='entries';");
        return statement.getResultSet();
    }

    @Override
    protected Connection connectToDB(DBStrings dBStrings) throws Exception {
        String string = SQLUtil.createJDBCurl(dBStrings, true);
        String string2 = "org.postgresql.Driver";
        Class.forName(string2).newInstance();
        return DriverManager.getConnection(string, dBStrings.getUsername(), dBStrings.getPassword());
    }
}

