/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;

public class UndoableKeyChange
extends AbstractUndoableEdit {
    private final String entryId;
    private final BibtexDatabase base;
    private final String oldValue;
    private final String newValue;

    public UndoableKeyChange(BibtexDatabase bibtexDatabase, String string, String string2, String string3) {
        this.base = bibtexDatabase;
        this.entryId = string;
        this.oldValue = string2;
        this.newValue = string3;
    }

    @Override
    public String getPresentationName() {
        return Globals.lang("change key");
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change key");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change key");
    }

    @Override
    public void undo() {
        super.undo();
        this.set(this.oldValue);
    }

    @Override
    public void redo() {
        super.redo();
        this.set(this.newValue);
    }

    private void set(String string) {
        this.base.setCiteKeyForEntry(this.entryId, string);
    }
}

