/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.IdGenerator;

public class UndoableRemoveEntry
extends AbstractUndoableEdit {
    private final BibtexDatabase base;
    private final BibtexEntry entry;
    private final BasePanel panel;

    public UndoableRemoveEntry(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, BasePanel basePanel) {
        this.base = bibtexDatabase;
        this.entry = bibtexEntry;
        this.panel = basePanel;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: remove entry";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: remove entry";
    }

    @Override
    public void undo() {
        super.undo();
        try {
            String string = IdGenerator.next();
            this.entry.setId(string);
            this.base.insertEntry(this.entry);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            this.base.removeEntry(this.entry.getId());
            this.panel.ensureNotShowing(this.entry);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

