/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;

public class UndoableRemoveString
extends AbstractUndoableEdit {
    private final BibtexDatabase base;
    private final BibtexString string;
    private final BasePanel panel;

    public UndoableRemoveString(BasePanel basePanel, BibtexDatabase bibtexDatabase, BibtexString bibtexString) {
        this.base = bibtexDatabase;
        this.string = bibtexString;
        this.panel = basePanel;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("remove string ");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("remove string ");
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.addString(this.string);
        }
        catch (KeyCollisionException keyCollisionException) {
            keyCollisionException.printStackTrace();
        }
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.base.removeString(this.string.getId());
        this.panel.updateStringDialog();
    }
}

