/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;

public class FileUtil {
    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1).trim().toLowerCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            if (file2.exists() && !bl) {
                boolean bl2 = false;
                return bl2;
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = bufferedInputStream.read()) >= 0) {
                bufferedOutputStream.write(n);
            }
        }
        finally {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return true;
    }

    public static boolean renameFile(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        return file.renameTo(file2);
    }

    public static File expandFilename(MetaData metaData, String string) {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 && n < string.length() - 1 ? string.substring(n + 1).trim().toLowerCase() : null;
        String[] stringArray = metaData.getFileDirectory(string2);
        String[] stringArray2 = metaData.getFileDirectory("file");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        for (String string3 : stringArray2) {
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
        return FileUtil.expandFilename(string, stringArray3);
    }

    public static File expandFilename(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            File file;
            if (string2 == null || (file = FileUtil.expandFilename(string, string2)) == null) continue;
            return file;
        }
        return null;
    }

    public static File expandFilename(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string);
        if (!file.exists() && string2 != null) {
            string = string2.endsWith(System.getProperty("file.separator")) ? string2 + string : string2 + System.getProperty("file.separator") + string;
            file = new File(string);
            if (file.exists()) {
                return file;
            }
            if (Globals.ON_WIN) {
                try {
                    string = string.replaceAll("/", "\\\\");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.err.println("An internal Java error was caused by the entry \"" + string + "\"");
                }
            } else {
                string = string.replaceAll("\\\\", "/");
            }
            if (!(file = new File(string)).exists()) {
                file = null;
            }
        }
        return file;
    }

    public static File shortenFileName(File file, String[] stringArray) {
        if (file == null || file.length() == 0L) {
            return file;
        }
        if (!file.isAbsolute() || stringArray == null) {
            return file;
        }
        for (String string : stringArray) {
            File file2;
            if (string == null || (file2 = FileUtil.shortenFileName(file, string)) == null || file2.equals(file)) continue;
            return file2;
        }
        return file;
    }

    private static File shortenFileName(File file, String string) {
        String string2;
        if (file == null || file.length() == 0L) {
            return file;
        }
        if (!file.isAbsolute() || string == null) {
            return file;
        }
        if (Globals.ON_WIN) {
            string2 = file.toString().toLowerCase();
            string = string.toLowerCase();
        } else {
            string2 = file.toString();
        }
        if (!string.endsWith(System.getProperty("file.separator"))) {
            string = string.concat(System.getProperty("file.separator"));
        }
        if (string2.startsWith(string)) {
            String string3 = file.toString().substring(string.length());
            return new File(string3);
        }
        return file;
    }
}

