/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameListNormalizer {
    private static final Pattern lastFF = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]+) (\\p{javaUpperCase}+)");
    private static final Pattern lastFdotF = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]+) ([\\. \\p{javaUpperCase}]+)");
    private static final Pattern FFlast = Pattern.compile("(\\p{javaUpperCase}+) (\\p{javaUpperCase}[\\p{javaLowerCase}]+)");
    private static final Pattern FdotFlast = Pattern.compile("([\\. \\p{javaUpperCase}]+) (\\p{javaUpperCase}[\\p{javaLowerCase}]+)");
    private static final Pattern SINGLE_NAME = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]*)");

    public static String normalizeAuthorList(String string) {
        boolean bl = false;
        String[] stringArray = string.split("( |,)and ", -1);
        if (stringArray.length > 1) {
            bl = true;
        } else {
            String[] stringArray2 = string.split("; ");
            if (stringArray2.length > 1) {
                stringArray = stringArray2;
            } else {
                stringArray2 = string.split(", ");
                if (stringArray2.length > 3) {
                    stringArray = stringArray2;
                } else if (stringArray2.length == 3 && stringArray2[1].length() > 3) {
                    stringArray = stringArray2;
                }
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (bl && stringArray.length == 2) {
            String[] stringArray3 = stringArray[0].split("; ");
            if (stringArray3.length > 1) {
                String[] stringArray4 = new String[1 + stringArray3.length];
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray4[i] = stringArray3[i].trim();
                }
                stringArray4[stringArray3.length] = stringArray[1];
                stringArray = stringArray4;
            } else {
                String[] stringArray5;
                boolean bl2;
                boolean bl3 = bl2 = stringArray[1].indexOf(",") > 0;
                if (!bl2 && (stringArray5 = stringArray[0].split(", ")).length > 1) {
                    String[] stringArray6 = new String[1 + stringArray5.length];
                    for (int i = 0; i < stringArray5.length; ++i) {
                        stringArray6[i] = stringArray5[i].trim();
                    }
                    stringArray6[stringArray5.length] = stringArray[1];
                    stringArray = stringArray6;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = NameListNormalizer.normalizeName(stringArray[i]);
            stringBuilder.append(string2);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(" and ");
        }
        return stringBuilder.toString();
    }

    private static String normalizeName(String string) {
        Matcher matcher = lastFF.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            StringBuilder stringBuilder = new StringBuilder(matcher.group(1));
            stringBuilder.append(", ");
            for (int i = 0; i < string2.length(); ++i) {
                stringBuilder.append(string2.charAt(i));
                stringBuilder.append('.');
                if (i >= string2.length() - 1) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        matcher = lastFdotF.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(2).replaceAll("[\\. ]+", "");
            StringBuilder stringBuilder = new StringBuilder(matcher.group(1));
            stringBuilder.append(", ");
            for (int i = 0; i < string3.length(); ++i) {
                stringBuilder.append(string3.charAt(i));
                stringBuilder.append('.');
                if (i >= string3.length() - 1) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        matcher = FFlast.matcher(string);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            StringBuilder stringBuilder = new StringBuilder(matcher.group(2));
            stringBuilder.append(", ");
            for (int i = 0; i < string4.length(); ++i) {
                stringBuilder.append(string4.charAt(i));
                stringBuilder.append('.');
                if (i >= string4.length() - 1) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        matcher = FdotFlast.matcher(string);
        if (matcher.matches()) {
            String string5 = matcher.group(1).replaceAll("[\\. ]+", "");
            StringBuilder stringBuilder = new StringBuilder(matcher.group(2));
            stringBuilder.append(", ");
            for (int i = 0; i < string5.length(); ++i) {
                stringBuilder.append(string5.charAt(i));
                stringBuilder.append('.');
                if (i >= string5.length() - 1) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        if (string.indexOf(44) >= 0) {
            int n = string.lastIndexOf(44);
            if (n == string.length() - 1) {
                string = string.substring(0, string.length() - 1);
            }
            StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
            stringBuilder.append(", ");
            String string6 = string.substring(n + 1).trim();
            String[] stringArray = string6.split(" ");
            if (stringArray.length > 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 1) {
                        stringBuilder.append(stringArray[i]).append('.');
                    } else {
                        stringBuilder.append(stringArray[i]);
                    }
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(' ');
                }
            } else {
                Matcher matcher2 = SINGLE_NAME.matcher(stringArray[0]);
                if (matcher2.matches()) {
                    stringBuilder.append(stringArray[0]);
                } else {
                    String string7 = stringArray[0].replaceAll("[\\.]+", "");
                    for (int i = 0; i < string7.length(); ++i) {
                        stringBuilder.append(string7.charAt(i));
                        stringBuilder.append('.');
                        if (i >= string7.length() - 1) continue;
                        stringBuilder.append(' ');
                    }
                }
            }
            return stringBuilder.toString();
        }
        String[] stringArray = string.split(" +");
        boolean bl = true;
        for (String string8 : stringArray) {
            matcher = SINGLE_NAME.matcher(string8);
            if (matcher.matches()) continue;
            bl = false;
            break;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(stringArray[stringArray.length - 1]);
            if (stringArray.length > 1) {
                stringBuilder.append(',');
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuilder.append(' ').append(stringArray[i]);
                    if (stringArray[i].length() != 1) continue;
                    stringBuilder.append('.');
                }
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

