/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class UtilFindFiles {
    public static String findPdf(String string, String string2, String string3, OpenFileFilter openFileFilter) {
        String string4;
        if (!string3.endsWith(System.getProperty("file.separator"))) {
            string3 = string3 + System.getProperty("file.separator");
        }
        if ((string4 = UtilFindFiles.findInDir(string, string3, openFileFilter, 0)) != null) {
            return string4.substring(string3.length());
        }
        return null;
    }

    public static Set<File> findFiles(Collection<String> collection, Collection<File> collection2) {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : collection2) {
            hashSet.addAll(UtilFindFiles.findFiles(collection, file));
        }
        return hashSet;
    }

    private static Collection<? extends File> findFiles(Collection<String> collection, File file) {
        HashSet<? extends File> hashSet = new HashSet<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return hashSet;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                hashSet.addAll(UtilFindFiles.findFiles(collection, file2));
                continue;
            }
            String string = FileUtil.getFileExtension(file2);
            if (string == null || !collection.contains(string)) continue;
            hashSet.add(file2);
        }
        return hashSet;
    }

    public static String findPdf(BibtexEntry bibtexEntry, String string, String string2) {
        return UtilFindFiles.findPdf(bibtexEntry, string, new String[]{string2});
    }

    public static String findPdf(BibtexEntry bibtexEntry, String string, String[] stringArray) {
        String string2 = Globals.prefs.getBoolean("useRegExpSearch") ? Globals.prefs.get("regExpSearchExpression") : Globals.prefs.get("defaultRegExpSearchExpression");
        string2 = string2.replaceAll("\\[extension\\]", string);
        return UtilFindFiles.findFile(bibtexEntry, null, stringArray, string2, true);
    }

    public static String findFile(BibtexEntry bibtexEntry, ExternalFileType externalFileType, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        if (Globals.prefs.hasKey(externalFileType.getExtension() + "Directory")) {
            arrayList.add(Globals.prefs.get(externalFileType.getExtension() + "Directory"));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return UtilFindFiles.findPdf(bibtexEntry, externalFileType.getExtension(), stringArray);
    }

    private static String findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String[] stringArray, String string, boolean bl) {
        for (String string2 : stringArray) {
            String string3 = UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, string2, string, bl);
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    public static String findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String string) {
        return UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, (String)null, string, false);
    }

    public static String findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String string, String string2, boolean bl) {
        File file = string == null ? new File(".") : new File(string);
        if (!file.exists()) {
            return null;
        }
        String string3 = UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, file, string2);
        if (string == null || !bl) {
            return string3;
        }
        if (string3 != null) {
            try {
                String string4 = string3.substring(file.getCanonicalPath().length());
                if (string4.length() > 1 && string4.charAt(0) == File.separatorChar) {
                    string4 = string4.substring(1);
                }
                return string4;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static String findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, File file, String string) {
        Object object;
        Object object2;
        if (string.startsWith("/")) {
            file = new File(".");
            string = string.substring(1);
        }
        Matcher matcher = Pattern.compile("([^\\\\])\\\\([^\\\\])").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1) + '/' + matcher.group(2));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        String[] stringArray = string.split("/");
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                Object object3;
                object2 = stringArray[i];
                if (((String)(object2 = Util.expandBrackets((String)object2, bibtexEntry, bibtexDatabase))).matches("^.:$")) {
                    file = new File((String)object2 + '/');
                    continue;
                }
                if (((String)object2).equals(".")) continue;
                if (((String)object2).equals("..")) {
                    file = new File(file.getParent());
                    continue;
                }
                if (((String)object2).equals("*")) {
                    object = file.listFiles();
                    if (object == null) {
                        return null;
                    }
                    object3 = StringUtil.join(stringArray, "/", i + 1, stringArray.length);
                    for (File file2 : object) {
                        String string2;
                        if (!file2.isDirectory() || (string2 = UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, file2, (String)object3)) == null) continue;
                        return string2;
                    }
                    return null;
                }
                if (((String)object2).equals("**")) {
                    object = new LinkedList();
                    object.add(file);
                    object3 = StringUtil.join(stringArray, "/", i + 1, stringArray.length);
                    String string3 = UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, file, (String)object3);
                    if (string3 != null) {
                        return string3;
                    }
                    while (!object.isEmpty()) {
                        File[] fileArray = ((File)object.remove(0)).listFiles();
                        if (fileArray == null) continue;
                        object.addAll(Arrays.asList(fileArray));
                        for (File file3 : fileArray) {
                            if (!file3.isDirectory() || (string3 = UtilFindFiles.findFile(bibtexEntry, bibtexDatabase, file3, (String)object3)) == null) continue;
                            return string3;
                        }
                    }
                    return null;
                }
                object = Pattern.compile(((String)object2).replaceAll("\\\\\\\\", "\\\\"));
                object3 = file.listFiles(new FilenameFilter((Pattern)object){
                    final /* synthetic */ Pattern val$toMatch;
                    {
                        this.val$toMatch = pattern;
                    }

                    @Override
                    public boolean accept(File file, String string) {
                        return this.val$toMatch.matcher(string).matches();
                    }
                });
                if (object3 == null || ((File[])object3).length == 0) {
                    return null;
                }
                file = object3[0];
                if (file.exists()) continue;
                return null;
            }
        }
        String string4 = Util.expandBrackets(stringArray[stringArray.length - 1], bibtexEntry, bibtexDatabase);
        object2 = Pattern.compile('^' + string4.replaceAll("\\\\\\\\", "\\\\") + '$');
        object = file.listFiles(new FilenameFilter((Pattern)object2){
            final /* synthetic */ Pattern val$toMatch;
            {
                this.val$toMatch = pattern;
            }

            @Override
            public boolean accept(File file, String string) {
                return this.val$toMatch.matcher(string).matches();
            }
        });
        if (object == null || ((File[])object).length == 0) {
            return null;
        }
        try {
            return object[0].getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String findInDir(String string, String string2, OpenFileFilter openFileFilter, int n) {
        if (n > 20) {
            return null;
        }
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        int n2 = fileArray.length;
        for (File file2 : fileArray) {
            String string3;
            if (file2.isFile()) {
                string3 = file2.getName();
                if (!string3.startsWith(string + '.') || !openFileFilter.accept(string3)) continue;
                return file2.getPath();
            }
            if (!file2.isDirectory() || (string3 = UtilFindFiles.findInDir(string, file2.getPath(), openFileFilter, n + 1)) == null) continue;
            return string3;
        }
        return null;
    }
}

