/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryWriter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.util.EncryptionNotSupportedException;
import net.sf.jabref.util.MonthUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.XMPSchemaBibtex;
import org.apache.jempbox.impl.DateConverter;
import org.apache.jempbox.impl.XMLUtil;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.w3c.dom.Node;

public class XMPUtil {
    public static List<BibtexEntry> readXMP(String string) throws IOException {
        return XMPUtil.readXMP(new File(string));
    }

    public static void writeXMP(String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) throws IOException, TransformerException {
        XMPUtil.writeXMP(new File(string), bibtexEntry, bibtexDatabase);
    }

    public static List<BibtexEntry> readXMP(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            List<BibtexEntry> list = XMPUtil.readXMP(fileInputStream);
            return list;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BibtexEntry> readXMP(InputStream inputStream) throws IOException {
        LinkedList<BibtexEntry> linkedList = new LinkedList<BibtexEntry>();
        PDDocument pDDocument = null;
        try {
            List<XMPSchema> list;
            pDDocument = PDDocument.load(inputStream);
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata xMPMetadata = XMPUtil.getXMPMetadata(pDDocument);
            if (xMPMetadata != null) {
                XMPSchema xMPSchema;
                list = xMPMetadata.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
                for (XMPSchema xMPSchema2 : list) {
                    xMPSchema = (XMPSchemaBibtex)xMPSchema2;
                    linkedList.add(xMPSchema.getBibtexEntry());
                }
                if (linkedList.isEmpty()) {
                    list = xMPMetadata.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
                    for (XMPSchema xMPSchema2 : list) {
                        xMPSchema = (XMPSchemaDublinCore)xMPSchema2;
                        BibtexEntry bibtexEntry = XMPUtil.getBibtexEntryFromDublinCore((XMPSchemaDublinCore)xMPSchema);
                        if (bibtexEntry == null) continue;
                        linkedList.add(bibtexEntry);
                    }
                }
            }
            if (linkedList.isEmpty() && (list = XMPUtil.getBibtexEntryFromDocumentInformation(pDDocument.getDocumentInformation())) != null) {
                linkedList.add((BibtexEntry)((Object)list));
            }
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList;
    }

    public static BibtexEntry getBibtexEntryFromDocumentInformation(PDDocumentInformation pDDocumentInformation) {
        BibtexEntry bibtexEntry = new BibtexEntry();
        String string = pDDocumentInformation.getAuthor();
        if (string != null) {
            bibtexEntry.setField("author", string);
        }
        if ((string = pDDocumentInformation.getTitle()) != null) {
            bibtexEntry.setField("title", string);
        }
        if ((string = pDDocumentInformation.getKeywords()) != null) {
            bibtexEntry.setField("keywords", string);
        }
        if ((string = pDDocumentInformation.getSubject()) != null) {
            bibtexEntry.setField("abstract", string);
        }
        COSDictionary cOSDictionary = pDDocumentInformation.getDictionary();
        for (Map.Entry<COSName, COSBase> entry : cOSDictionary.entrySet()) {
            String string2 = entry.getKey().getName();
            if (!string2.startsWith("bibtex/")) continue;
            String string3 = cOSDictionary.getString(string2);
            if ((string2 = string2.substring("bibtex/".length())).equals("entrytype")) {
                BibtexEntryType bibtexEntryType = BibtexEntryType.getStandardType(string3);
                if (bibtexEntryType == null) continue;
                bibtexEntry.setType(bibtexEntryType);
                continue;
            }
            bibtexEntry.setField(string2, string3);
        }
        return !bibtexEntry.getAllFields().isEmpty() ? bibtexEntry : null;
    }

    public static BibtexEntry getBibtexEntryFromDublinCore(XMPSchemaDublinCore xMPSchemaDublinCore) {
        BibtexEntryType bibtexEntryType;
        Object object;
        List<String> list;
        Object object2;
        Object object3;
        CharSequence charSequence;
        Object object4;
        Object object5;
        BibtexEntry bibtexEntry = new BibtexEntry();
        List<String> list2 = xMPSchemaDublinCore.getContributors();
        if (list2 != null) {
            object5 = list2.iterator();
            object4 = null;
            while (object5.hasNext()) {
                if (object4 != null) {
                    ((StringBuffer)object4).append(" and ");
                } else {
                    object4 = new StringBuffer();
                }
                ((StringBuffer)object4).append((String)object5.next());
            }
            if (object4 != null) {
                bibtexEntry.setField("editor", ((StringBuffer)object4).toString());
            }
        }
        if ((object5 = xMPSchemaDublinCore.getCreators()) != null) {
            object4 = object5.iterator();
            charSequence = null;
            while (object4.hasNext()) {
                if (charSequence != null) {
                    ((StringBuffer)charSequence).append(" and ");
                } else {
                    charSequence = new StringBuffer();
                }
                ((StringBuffer)charSequence).append((String)object4.next());
            }
            if (charSequence != null) {
                bibtexEntry.setField("author", ((StringBuffer)charSequence).toString());
            }
        }
        if ((object4 = xMPSchemaDublinCore.getSequenceList("dc:date")) != null && !object4.isEmpty()) {
            charSequence = ((String)object4.get(0)).trim();
            object3 = null;
            try {
                object3 = DateConverter.toCalendar((String)charSequence);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object3 != null) {
                bibtexEntry.setField("year", String.valueOf(((Calendar)object3).get(1)));
                if (((String)charSequence).length() > 4) {
                    bibtexEntry.setField("month", MonthUtil.getMonthByIndex((int)((Calendar)object3).get((int)2)).bibtexFormat);
                }
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getDescription()) != null) {
            bibtexEntry.setField("abstract", (String)charSequence);
        }
        if ((charSequence = xMPSchemaDublinCore.getIdentifier()) != null) {
            bibtexEntry.setField("doi", (String)charSequence);
        }
        if ((object3 = xMPSchemaDublinCore.getPublishers()) != null) {
            object2 = xMPSchemaDublinCore.getPublishers().iterator();
            list = null;
            while (object2.hasNext()) {
                if (list != null) {
                    ((StringBuffer)((Object)list)).append(" and ");
                } else {
                    list = new StringBuffer();
                }
                ((StringBuffer)((Object)list)).append((String)object2.next());
            }
            if (list != null) {
                bibtexEntry.setField("publishers", ((StringBuffer)((Object)list)).toString());
            }
        }
        if ((object2 = xMPSchemaDublinCore.getRelationships()) != null) {
            list = object2.iterator();
            while (list.hasNext()) {
                int n;
                object = (String)list.next();
                if (!((String)object).startsWith("bibtex/") || (n = ((String)(object = ((String)object).substring("bibtex/".length()))).indexOf(47)) == -1) continue;
                bibtexEntry.setField(((String)object).substring(0, n), ((String)object).substring(n + 1));
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getRights()) != null) {
            bibtexEntry.setField("rights", (String)charSequence);
        }
        if ((charSequence = xMPSchemaDublinCore.getSource()) != null) {
            bibtexEntry.setField("source", (String)charSequence);
        }
        if ((list = xMPSchemaDublinCore.getSubjects()) != null) {
            object = list.iterator();
            StringBuffer stringBuffer = null;
            while (object.hasNext()) {
                if (stringBuffer != null) {
                    stringBuffer.append(',');
                } else {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append((String)object.next());
            }
            if (stringBuffer != null) {
                bibtexEntry.setField("keywords", stringBuffer.toString());
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getTitle()) != null) {
            bibtexEntry.setField("title", (String)charSequence);
        }
        if ((object = xMPSchemaDublinCore.getTypes()) != null && !object.isEmpty() && (charSequence = object.get(0)) != null && (bibtexEntryType = BibtexEntryType.getStandardType((String)charSequence)) != null) {
            bibtexEntry.setType(bibtexEntryType);
        }
        return !bibtexEntry.getAllFields().isEmpty() ? bibtexEntry : null;
    }

    public static void writeXMP(File file, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) throws IOException, TransformerException {
        LinkedList<BibtexEntry> linkedList = new LinkedList<BibtexEntry>();
        linkedList.add(bibtexEntry);
        XMPUtil.writeXMP(file, linkedList, bibtexDatabase, true);
    }

    private static void toXMP(Collection<BibtexEntry> collection, BibtexDatabase bibtexDatabase, OutputStream outputStream) throws IOException, TransformerException {
        if (bibtexDatabase != null) {
            collection = bibtexDatabase.resolveForStrings(collection, true);
        }
        XMPMetadata xMPMetadata = new XMPMetadata();
        for (BibtexEntry bibtexEntry : collection) {
            XMPSchemaBibtex xMPSchemaBibtex = new XMPSchemaBibtex(xMPMetadata);
            xMPMetadata.addSchema(xMPSchemaBibtex);
            xMPSchemaBibtex.setBibtexEntry(bibtexEntry);
        }
        xMPMetadata.save(outputStream);
    }

    public static String toXMP(Collection<BibtexEntry> collection, BibtexDatabase bibtexDatabase) throws TransformerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMPUtil.toXMP(collection, bibtexDatabase, byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    private static XMPMetadata readRawXMP(InputStream inputStream) throws IOException {
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load(inputStream);
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata xMPMetadata = XMPUtil.getXMPMetadata(pDDocument);
            return xMPMetadata;
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
    }

    private static XMPMetadata getXMPMetadata(PDDocument pDDocument) throws IOException {
        PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
        PDMetadata pDMetadata = pDDocumentCatalog.getMetadata();
        if (pDMetadata == null) {
            return null;
        }
        XMPMetadata xMPMetadata = new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream()));
        xMPMetadata.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
        return xMPMetadata;
    }

    public static XMPMetadata readRawXMP(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            XMPMetadata xMPMetadata = XMPUtil.readRawXMP(fileInputStream);
            return xMPMetadata;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static void writeToDCSchema(XMPSchemaDublinCore xMPSchemaDublinCore, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        if (bibtexDatabase != null) {
            bibtexEntry = bibtexDatabase.resolveForStrings(bibtexEntry, false);
        }
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        boolean bl = jabRefPreferences.getBoolean("useXmpPrivacyFilter");
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(jabRefPreferences.getStringArray("xmpPrivacyFilters")));
        for (String string : bibtexEntry.getAllFields()) {
            int n;
            String[] stringArray;
            String string2;
            if (bl && treeSet.contains(string)) continue;
            if (string.equals("editor")) {
                string2 = bibtexEntry.getField(string);
                stringArray = AuthorList.getAuthorList(string2);
                int n2 = stringArray.size();
                for (n = 0; n < n2; ++n) {
                    xMPSchemaDublinCore.addContributor(stringArray.getAuthor(n).getFirstLast(false));
                }
                continue;
            }
            if (string.equals("author")) {
                string2 = bibtexEntry.getField(string);
                stringArray = AuthorList.getAuthorList(string2);
                int n3 = stringArray.size();
                for (n = 0; n < n3; ++n) {
                    xMPSchemaDublinCore.addCreator(stringArray.getAuthor(n).getFirstLast(false));
                }
                continue;
            }
            if (string.equals("month")) continue;
            if (string.equals("year")) {
                string2 = Util.getPublicationDate(bibtexEntry);
                if (string2 == null) continue;
                xMPSchemaDublinCore.addSequenceValue("dc:date", string2);
                continue;
            }
            if (string.equals("abstract")) {
                string2 = bibtexEntry.getField(string);
                xMPSchemaDublinCore.setDescription(string2);
                continue;
            }
            if (string.equals("doi")) {
                string2 = bibtexEntry.getField(string);
                xMPSchemaDublinCore.setIdentifier(string2);
                continue;
            }
            if (string.equals("publisher")) {
                string2 = bibtexEntry.getField(string);
                xMPSchemaDublinCore.addPublisher(string2);
                continue;
            }
            if (string.equals("keywords")) {
                string2 = bibtexEntry.getField(string);
                String[] stringArray2 = stringArray = string2.split(",");
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray2[i];
                    xMPSchemaDublinCore.addSubject(string3.trim());
                }
                continue;
            }
            if (string.equals("title")) {
                string2 = bibtexEntry.getField(string);
                xMPSchemaDublinCore.setTitle(string2);
                continue;
            }
            string2 = bibtexEntry.getField(string);
            xMPSchemaDublinCore.addRelation("bibtex/" + string + '/' + string2);
        }
        xMPSchemaDublinCore.setFormat("application/pdf");
        String string = bibtexEntry.getType().getName();
        if (string != null) {
            xMPSchemaDublinCore.addType(string.toString());
        }
    }

    public static void writeDublinCore(PDDocument pDDocument, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) throws IOException, TransformerException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.add(bibtexEntry);
        XMPUtil.writeDublinCore(pDDocument, arrayList, bibtexDatabase);
    }

    private static void writeDublinCore(PDDocument pDDocument, Collection<BibtexEntry> collection, BibtexDatabase bibtexDatabase) throws IOException, TransformerException {
        Object object;
        PDDocumentCatalog pDDocumentCatalog;
        PDMetadata pDMetadata;
        if (bibtexDatabase != null) {
            collection = bibtexDatabase.resolveForStrings(collection, false);
        }
        XMPMetadata xMPMetadata = (pDMetadata = (pDDocumentCatalog = pDDocument.getDocumentCatalog()).getMetadata()) != null ? new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream())) : new XMPMetadata();
        List<XMPSchema> list = xMPMetadata.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
        for (XMPSchema object22 : list) {
            object22.getElement().getParentNode().removeChild(object22.getElement());
        }
        for (BibtexEntry bibtexEntry : collection) {
            object = new XMPSchemaDublinCore(xMPMetadata);
            XMPUtil.writeToDCSchema((XMPSchemaDublinCore)object, bibtexEntry, null);
            xMPMetadata.addSchema((XMPSchema)object);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xMPMetadata.save(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        object = new PDMetadata(pDDocument, byteArrayInputStream, false);
        pDDocumentCatalog.setMetadata((PDMetadata)object);
    }

    private static void writeDocumentInformation(PDDocument pDDocument, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
        if (bibtexDatabase != null) {
            bibtexEntry = bibtexDatabase.resolveForStrings(bibtexEntry, false);
        }
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        boolean bl = jabRefPreferences.getBoolean("useXmpPrivacyFilter");
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(jabRefPreferences.getStringArray("xmpPrivacyFilters")));
        Set<String> set = bibtexEntry.getAllFields();
        for (String string : set) {
            if (bl && treeSet.contains(string)) {
                if (string.equals("author")) {
                    pDDocumentInformation.setAuthor(null);
                    continue;
                }
                if (string.equals("title")) {
                    pDDocumentInformation.setTitle(null);
                    continue;
                }
                if (string.equals("keywords")) {
                    pDDocumentInformation.setKeywords(null);
                    continue;
                }
                if (string.equals("abstract")) {
                    pDDocumentInformation.setSubject(null);
                    continue;
                }
                pDDocumentInformation.setCustomMetadataValue("bibtex/" + string, null);
                continue;
            }
            if (string.equals("author")) {
                pDDocumentInformation.setAuthor(bibtexEntry.getField("author"));
                continue;
            }
            if (string.equals("title")) {
                pDDocumentInformation.setTitle(bibtexEntry.getField("title"));
                continue;
            }
            if (string.equals("keywords")) {
                pDDocumentInformation.setKeywords(bibtexEntry.getField("keywords"));
                continue;
            }
            if (string.equals("abstract")) {
                pDDocumentInformation.setSubject(bibtexEntry.getField("abstract"));
                continue;
            }
            pDDocumentInformation.setCustomMetadataValue("bibtex/" + string, bibtexEntry.getField(string));
        }
        pDDocumentInformation.setCustomMetadataValue("bibtex/entrytype", bibtexEntry.getType().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMP(File file, Collection<BibtexEntry> collection, BibtexDatabase bibtexDatabase, boolean bl) throws IOException, TransformerException {
        if (bibtexDatabase != null) {
            collection = bibtexDatabase.resolveForStrings(collection, false);
        }
        PDDocument pDDocument = null;
        try {
            Object object;
            PDDocumentCatalog pDDocumentCatalog;
            PDMetadata pDMetadata;
            pDDocument = PDDocument.load(file.getAbsoluteFile());
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot add metadata to encrypted document.");
            }
            if (bl && collection.size() == 1) {
                XMPUtil.writeDocumentInformation(pDDocument, collection.iterator().next(), null);
                XMPUtil.writeDublinCore(pDDocument, collection, null);
            }
            XMPMetadata xMPMetadata = (pDMetadata = (pDDocumentCatalog = pDDocument.getDocumentCatalog()).getMetadata()) != null ? new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream())) : new XMPMetadata();
            xMPMetadata.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
            List<XMPSchema> list = xMPMetadata.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
            for (XMPSchema object22 : list) {
                object = (XMPSchemaBibtex)object22;
                ((XMPSchema)object).getElement().getParentNode().removeChild(((XMPSchema)object).getElement());
            }
            for (BibtexEntry bibtexEntry : collection) {
                object = new XMPSchemaBibtex(xMPMetadata);
                xMPMetadata.addSchema((XMPSchema)object);
                ((XMPSchemaBibtex)object).setBibtexEntry(bibtexEntry, null);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xMPMetadata.save(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object = new PDMetadata(pDDocument, byteArrayInputStream, false);
            pDDocumentCatalog.setMetadata((PDMetadata)object);
            try {
                pDDocument.save(file.getAbsolutePath());
            }
            catch (COSVisitorException cOSVisitorException) {
                throw new TransformerException("Could not write XMP-metadata: " + cOSVisitorException.getLocalizedMessage());
            }
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
    }

    private static void usage() {
        System.out.println("Read or write XMP-metadata from or to pdf file.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("Read from PDF and print as bibtex:");
        System.out.println("  xmpUtil <pdf>");
        System.out.println("Read from PDF and print raw XMP:");
        System.out.println("  xmpUtil -x <pdf>");
        System.out.println("Write the entry in <bib> given by <key> to the PDF:");
        System.out.println("  xmpUtil <key> <bib> <pdf>");
        System.out.println("Write all entries in <bib> to the PDF:");
        System.out.println("  xmpUtil <bib> <pdf>");
        System.out.println("");
        System.out.println("To report bugs visit http://jabref.sourceforge.net");
    }

    public static void main(String[] stringArray) throws IOException, TransformerException {
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        switch (stringArray.length) {
            case 0: {
                XMPUtil.usage();
                break;
            }
            case 1: {
                if (stringArray[0].endsWith(".pdf")) {
                    List<BibtexEntry> list = XMPUtil.readXMP(new File(stringArray[0]));
                    BibtexEntryWriter bibtexEntryWriter = new BibtexEntryWriter(new LatexFieldFormatter(), false);
                    for (BibtexEntry bibtexEntry : list) {
                        StringWriter stringWriter = new StringWriter();
                        bibtexEntryWriter.write(bibtexEntry, stringWriter);
                        System.out.println(stringWriter.getBuffer().toString());
                    }
                    break;
                }
                if (stringArray[0].endsWith(".bib")) {
                    ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[0]));
                    Collection<BibtexEntry> collection = parserResult.getDatabase().getEntries();
                    if (collection.isEmpty()) {
                        System.err.println("Could not find BibtexEntry in " + stringArray[0]);
                        break;
                    }
                    System.out.println(XMPUtil.toXMP(collection, parserResult.getDatabase()));
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 2: {
                if (stringArray[0].equals("-x") && stringArray[1].endsWith(".pdf")) {
                    XMPMetadata xMPMetadata = XMPUtil.readRawXMP(new File(stringArray[1]));
                    if (xMPMetadata == null) {
                        System.err.println("The given pdf does not contain any XMP-metadata.");
                        break;
                    }
                    XMLUtil.save((Node)xMPMetadata.getXMPDocument(), System.out, "UTF-8");
                    break;
                }
                if (stringArray[0].endsWith(".bib") && stringArray[1].endsWith(".pdf")) {
                    ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[0]));
                    Collection<BibtexEntry> collection = parserResult.getDatabase().getEntries();
                    if (collection.isEmpty()) {
                        System.err.println("Could not find BibtexEntry in " + stringArray[0]);
                        break;
                    }
                    XMPUtil.writeXMP(new File(stringArray[1]), collection, parserResult.getDatabase(), false);
                    System.out.println("XMP written.");
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 3: {
                if (!stringArray[1].endsWith(".bib") && !stringArray[2].endsWith(".pdf")) {
                    XMPUtil.usage();
                    break;
                }
                ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[1]));
                BibtexEntry bibtexEntry = parserResult.getDatabase().getEntryByKey(stringArray[0]);
                if (bibtexEntry == null) {
                    System.err.println("Could not find BibtexEntry " + stringArray[0] + " in " + stringArray[0]);
                    break;
                }
                XMPUtil.writeXMP(new File(stringArray[2]), bibtexEntry, parserResult.getDatabase());
                System.out.println("XMP written.");
                break;
            }
            default: {
                XMPUtil.usage();
            }
        }
    }

    public static boolean hasMetadata(InputStream inputStream) {
        try {
            List<BibtexEntry> list = XMPUtil.readXMP(inputStream);
            return !list.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

