/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util.error;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.sf.jabref.util.error.TeeStream;

public class StreamEavesdropper {
    private final ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    private final PrintStream systemOut;
    private final PrintStream systemErr;

    public static StreamEavesdropper eavesdropOnSystem() {
        StreamEavesdropper streamEavesdropper = new StreamEavesdropper(System.out, System.err);
        System.setOut(streamEavesdropper.getOutStream());
        System.setErr(streamEavesdropper.getErrStream());
        return streamEavesdropper;
    }

    public StreamEavesdropper(PrintStream printStream, PrintStream printStream2) {
        this.systemOut = printStream;
        this.systemErr = printStream2;
    }

    public PrintStream getOutStream() {
        PrintStream printStream = new PrintStream(this.outByteStream);
        return new TeeStream(printStream, this.systemOut);
    }

    public PrintStream getErrStream() {
        PrintStream printStream = new PrintStream(this.errByteStream);
        return new TeeStream(printStream, this.systemErr);
    }

    public String getErrorMessages() {
        return this.errByteStream.toString();
    }

    public String getOutput() {
        return this.outByteStream.toString();
    }
}

