/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;

public class AuxCommandLine {
    private final String auxName;
    private final BibtexDatabase bib;

    public AuxCommandLine(String string, BibtexDatabase bibtexDatabase) {
        this.auxName = StringUtil.getCorrectFileName(string, "aux");
        this.bib = bibtexDatabase;
    }

    public BibtexDatabase perform() {
        BibtexDatabase bibtexDatabase = null;
        if (this.auxName.length() > 0 && this.bib != null) {
            int n;
            AuxSubGenerator auxSubGenerator = new AuxSubGenerator(this.bib);
            Vector<String> vector = auxSubGenerator.generate(this.auxName, this.bib);
            bibtexDatabase = auxSubGenerator.getGeneratedDatabase();
            System.out.println(Globals.lang("keys_in_database") + " " + this.bib.getEntryCount());
            System.out.println(Globals.lang("found_in_aux_file") + " " + auxSubGenerator.getFoundKeysInAux());
            System.out.println(Globals.lang("resolved") + " " + auxSubGenerator.getResolvedKeysCount());
            if (auxSubGenerator.getNotResolvedKeysCount() > 0) {
                System.out.println(Globals.lang("not_found") + " " + auxSubGenerator.getNotResolvedKeysCount());
                System.out.println(vector);
            }
            if ((n = auxSubGenerator.getNestedAuxCounter()) > 0) {
                System.out.println(Globals.lang("nested_aux_files") + " " + n);
            }
        }
        return bibtexDatabase;
    }
}

