/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_Cancel_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_generate_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_parse_actionAdapter;

public class FromAuxDialog
extends JDialog {
    private final JPanel statusPanel = new JPanel();
    private final JPanel buttons = new JPanel();
    private final JButton selectInDBButton = new JButton();
    private final JButton generateButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton parseButton = new JButton();
    private final JComboBox dbChooser = new JComboBox();
    private JTextField auxFileField;
    private JList notFoundList;
    private JTextArea statusInfos;
    private final JTabbedPane parentTabbedPane;
    private boolean generatePressed = false;
    private final AuxSubGenerator auxParser;

    public FromAuxDialog(JabRefFrame jabRefFrame, String string, boolean bl, JTabbedPane jTabbedPane) {
        super(jabRefFrame, string, bl);
        this.parentTabbedPane = jTabbedPane;
        this.auxParser = new AuxSubGenerator(null);
        try {
            this.jbInit(jabRefFrame);
            this.pack();
            this.setSize(600, 500);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(JabRefFrame jabRefFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.selectInDBButton.setText(Globals.lang("Select"));
        this.selectInDBButton.setEnabled(false);
        this.selectInDBButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FromAuxDialog.this.select_actionPerformed();
            }
        });
        this.generateButton.setText(Globals.lang("Generate"));
        this.generateButton.setEnabled(false);
        this.generateButton.addActionListener(new FromAuxDialog_generate_actionAdapter(this));
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(new FromAuxDialog_Cancel_actionAdapter(this));
        this.parseButton.setText(Globals.lang("Parse"));
        this.parseButton.addActionListener(new FromAuxDialog_parse_actionAdapter(this));
        this.initPanels(jabRefFrame);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        JPanel jPanel2 = buttonBarBuilder.getPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.parseButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton((JComponent)this.selectInDBButton);
        buttonBarBuilder.addButton((JComponent)this.generateButton);
        buttonBarBuilder.addButton((JComponent)this.cancelButton);
        buttonBarBuilder.addGlue();
        this.setModal(true);
        this.setResizable(true);
        this.setTitle(Globals.lang("AUX file import"));
        JLabel jLabel = new JLabel("<html><h3>" + Globals.lang("AUX file import") + "</h3><p>" + Globals.lang("This feature generates a new database based on which entries are needed in an existing LaTeX document.") + "</p>" + "<p>" + Globals.lang("You need to select one of your open databases from which to choose entries, as well as the AUX file produced by LaTeX when compiling your document.") + "</p></html>");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.buttons, "North");
        jPanel3.add((Component)this.statusPanel, "Center");
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        ActionMap actionMap = this.statusPanel.getActionMap();
        InputMap inputMap = this.statusPanel.getInputMap(2);
        inputMap.put(jabRefFrame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FromAuxDialog.this.dispose();
            }
        });
    }

    private void initPanels(JabRefFrame jabRefFrame) {
        int n = this.parentTabbedPane.getTabCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            this.dbChooser.addItem(this.parentTabbedPane.getTitleAt(i));
            if (jabRefFrame.baseAt(i) != jabRefFrame.basePanel()) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            this.dbChooser.setSelectedIndex(n2);
        }
        this.auxFileField = new JTextField("", 25);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(this.auxFileField, jabRefFrame));
        this.notFoundList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.notFoundList);
        this.statusInfos = new JTextArea("", 5, 20);
        JScrollPane jScrollPane2 = new JScrollPane(this.statusInfos);
        this.statusInfos.setEditable(false);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, left:pref", ""), this.buttons);
        defaultFormBuilder.appendSeparator(Globals.lang("Options"));
        defaultFormBuilder.append(Globals.lang("Reference database") + ":");
        defaultFormBuilder.append((Component)this.dbChooser, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("LaTeX AUX file") + ":");
        defaultFormBuilder.append(this.auxFileField);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref:grow", "pref, pref, fill:pref:grow"), this.statusPanel);
        defaultFormBuilder.appendSeparator(Globals.lang("Result"));
        defaultFormBuilder.append(Globals.lang("Unknown bibtex entries") + ":");
        defaultFormBuilder.append(Globals.lang("Messages") + ":");
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jScrollPane);
        defaultFormBuilder.append(jScrollPane2);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    void generate_actionPerformed(ActionEvent actionEvent) {
        this.generatePressed = true;
        this.dispose();
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void select_actionPerformed() {
        BibtexDatabase bibtexDatabase = this.getGenerateDB();
        MainTable mainTable = JabRef.jrf.basePanel().mainTable;
        BibtexDatabase bibtexDatabase2 = JabRef.jrf.basePanel().getDatabase();
        mainTable.clearSelection();
        for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
            BibtexEntry bibtexEntry2 = bibtexDatabase2.getEntryByKey(bibtexEntry.getCiteKey());
            int n = mainTable.findEntry(bibtexEntry2);
            mainTable.addSelection(n);
        }
    }

    void parse_actionPerformed(ActionEvent actionEvent) {
        this.parseButton.setEnabled(false);
        BasePanel basePanel = (BasePanel)this.parentTabbedPane.getComponentAt(this.dbChooser.getSelectedIndex());
        this.notFoundList.removeAll();
        this.statusInfos.setText(null);
        BibtexDatabase bibtexDatabase = basePanel.getDatabase();
        String string = this.auxFileField.getText();
        if (string != null && bibtexDatabase != null && string.length() > 0) {
            this.auxParser.clear();
            this.notFoundList.setListData(this.auxParser.generate(string, bibtexDatabase));
            this.statusInfos.append(Globals.lang("keys in database") + " " + bibtexDatabase.getEntryCount());
            this.statusInfos.append("\n" + Globals.lang("found in aux file") + " " + this.auxParser.getFoundKeysInAux());
            this.statusInfos.append("\n" + Globals.lang("resolved") + " " + this.auxParser.getResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("not found") + " " + this.auxParser.getNotResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("crossreferenced entries included") + " " + this.auxParser.getCrossreferencedEntriesCount());
            int n = this.auxParser.getNestedAuxCounter();
            if (n > 0) {
                this.statusInfos.append("\n" + Globals.lang("nested_aux_files") + " " + n);
            }
            this.selectInDBButton.setEnabled(true);
            this.generateButton.setEnabled(true);
        }
        if (this.auxParser.getGeneratedDatabase().getEntryCount() < 1) {
            this.statusInfos.append("\n" + Globals.lang("empty database"));
            this.generateButton.setEnabled(false);
        }
        this.parseButton.setEnabled(true);
    }

    public boolean generatePressed() {
        return this.generatePressed;
    }

    public BibtexDatabase getGenerateDB() {
        return this.auxParser.getGeneratedDatabase();
    }

    static class BrowseAction
    extends AbstractAction {
        private final JTextField comp;
        private final JabRefFrame _frame;

        public BrowseAction(JTextField jTextField, JabRefFrame jabRefFrame) {
            super(Globals.lang("Browse"));
            this._frame = jabRefFrame;
            this.comp = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FileDialogs.getNewFile(this._frame, new File(this.comp.getText()), ".aux", 0, false);
            if (string != null) {
                File file = new File(string);
                this.comp.setText(file.getPath());
            }
        }
    }
}

