/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.wizard.integrity.gui.IntegrityMessagePanel;

public class IntegrityWizard
extends JDialog
implements ActionListener {
    private final BibtexDatabase dbase;
    private final BasePanel basePanel;
    private JButton closeButton;
    private JButton startButton;
    private IntegrityMessagePanel warnPanel;

    public IntegrityWizard(JabRefFrame jabRefFrame, BasePanel basePanel) {
        super(jabRefFrame, "dialog", false);
        this.basePanel = basePanel;
        this.dbase = basePanel.database();
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.setResizable(false);
        this.setTitle(Globals.lang("Integrity_check"));
        this.warnPanel = new IntegrityMessagePanel(this.basePanel);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        this.startButton = new JButton(Globals.lang("Scan"));
        this.startButton.addActionListener(this);
        this.closeButton = new JButton(Globals.lang("Close"));
        this.closeButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.startButton, gridBagConstraints);
        jPanel.add(this.startButton);
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        jPanel.add(this.closeButton);
        JEditorPane jEditorPane = null;
        URL uRL = JabRef.class.getResource(GUIGlobals.getLocaleHelpPath() + "ShortIntegrityCheck.html");
        if (uRL != null) {
            try {
                jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                jEditorPane.setPreferredSize(new Dimension(220, 60));
                jEditorPane.setMinimumSize(new Dimension(180, 50));
                jEditorPane.setPage(uRL);
                jEditorPane.setBackground(GUIGlobals.infoField);
                jEditorPane.setBorder(new EtchedBorder(1));
            }
            catch (IOException iOException) {
                jEditorPane = null;
            }
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        if (jEditorPane != null) {
            container.add((Component)jEditorPane, "First");
        }
        container.add((Component)this.warnPanel, "Center");
        container.add((Component)jPanel, "Last");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dispose();
        } else if (object == this.startButton) {
            this.startButton.setEnabled(false);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IntegrityWizard.this.warnPanel.updateView(IntegrityWizard.this.dbase);
                }
            };
            SwingUtilities.invokeLater(runnable);
            this.startButton.setEnabled(true);
        }
    }
}

