/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.imports.PdfContentImporter;
import net.sf.jabref.imports.PdfXmpImporter;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.XMPUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sciplore.beans.Document;
import spl.DocumentWrapper;
import spl.Tools;
import spl.filter.PdfFileFilter;
import spl.gui.ImportDialog;
import spl.gui.MetaDataListDialog;

public class PdfImporter {
    private final JabRefFrame frame;
    private final BasePanel panel;
    private MainTable entryTable;
    private int dropRow;
    private static final Log LOGGER = LogFactory.getLog(PdfImporter.class);

    public PdfImporter(JabRefFrame jabRefFrame, BasePanel basePanel, MainTable mainTable, int n) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.entryTable = mainTable;
        this.dropRow = n;
    }

    public ImportPdfFilesResult importPdfFiles(String[] stringArray, OutputPrinter outputPrinter) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PdfFileFilter pdfFileFilter = new PdfFileFilter();
        for (String stringArray22 : arrayList) {
            if (pdfFileFilter.accept(stringArray22)) continue;
            arrayList2.add(stringArray22);
        }
        arrayList.removeAll(arrayList2);
        List<BibtexEntry> list = this.importPdfFiles(arrayList, outputPrinter);
        String[] stringArray2 = new String[arrayList2.size()];
        arrayList2.toArray(stringArray2);
        ImportPdfFilesResult importPdfFilesResult = new ImportPdfFilesResult();
        importPdfFilesResult.noPdfFiles = stringArray2;
        importPdfFilesResult.entries = list;
        return importPdfFilesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BibtexEntry> importPdfFiles(List<String> list, OutputPrinter outputPrinter) {
        if (this.panel == null) {
            return Collections.emptyList();
        }
        ImportDialog importDialog = null;
        boolean bl = false;
        boolean bl2 = Globals.prefs.getBoolean("importAlwaysUsePDFImportStyle");
        int n = Globals.prefs.getInt("importDefaultPDFimportStyle");
        String[] stringArray = this.panel.metaData().getFileDirectory("file");
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        for (String string : list) {
            block51: {
                List<BibtexEntry> list2 = this.readXmpEntries(string);
                if (!bl2 && !bl) {
                    importDialog = new ImportDialog(this.dropRow >= 0, string);
                    if (!this.hasXmpEntries(list2)) {
                        importDialog.disableXMPChoice();
                    }
                    Tools.centerRelativeToWindow(importDialog, this.frame);
                    importDialog.showDialog();
                    bl = importDialog.getDoNotShowAgain();
                }
                if (!bl2 && importDialog.getResult() != 0) break block51;
                int n2 = bl2 ? n : importDialog.getChoice();
                FileInputStream fileInputStream = null;
                List<BibtexEntry> list3 = null;
                switch (n2) {
                    case 1: {
                        BibtexEntry bibtexEntry;
                        PdfXmpImporter pdfXmpImporter = new PdfXmpImporter();
                        try {
                            fileInputStream = new FileInputStream(string);
                            list3 = pdfXmpImporter.importEntries(fileInputStream, this.frame);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        finally {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (Exception exception) {}
                        }
                        if (list3 == null || list3.size() == 0) {
                            LOGGER.info(Globals.lang("Import failed"));
                            bibtexEntry = this.createNewBlankEntry(string);
                            arrayList.add(bibtexEntry);
                            break;
                        }
                        bibtexEntry = list3.get(0);
                        this.panel.database().insertEntry(bibtexEntry);
                        this.panel.markBaseChanged();
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        File file = new File(string);
                        fileListTableModel.addEntry(0, new FileListEntry(file.getName(), FileUtil.shortenFileName(file, stringArray).getPath(), Globals.prefs.getExternalFileTypeByName("pdf")));
                        bibtexEntry.setField("file", fileListTableModel.getStringRepresentation());
                        arrayList.add(bibtexEntry);
                        break;
                    }
                    case 2: {
                        Object object;
                        BibtexEntry bibtexEntry;
                        PdfContentImporter pdfContentImporter = new PdfContentImporter();
                        File file = new File(string);
                        try {
                            fileInputStream = new FileInputStream(file);
                        }
                        catch (Exception exception) {
                            LOGGER.info(Globals.lang("Import failed"), exception);
                            exception.printStackTrace();
                            bibtexEntry = this.createNewBlankEntry(string);
                            arrayList.add(bibtexEntry);
                            break;
                        }
                        try {
                            list3 = pdfContentImporter.importEntries(fileInputStream, outputPrinter);
                        }
                        catch (Exception exception) {
                            LOGGER.info(Globals.lang("Import failed"), exception);
                            exception.printStackTrace();
                            bibtexEntry = this.createNewBlankEntry(string);
                            arrayList.add(bibtexEntry);
                            break;
                        }
                        finally {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (Exception exception) {}
                        }
                        if (list3 == null || list3.size() == 0) {
                            bibtexEntry = this.createNewBlankEntry(string);
                            arrayList.add(bibtexEntry);
                            break;
                        }
                        bibtexEntry = list3.get(0);
                        this.panel.database().insertEntry(bibtexEntry);
                        this.panel.markBaseChanged();
                        LabelPatternUtil.makeLabel(this.panel.metaData(), this.panel.database(), bibtexEntry);
                        DroppedFileHandler droppedFileHandler = new DroppedFileHandler(this.frame, this.panel);
                        droppedFileHandler.linkPdfToEntry(string, this.entryTable, bibtexEntry);
                        this.panel.highlightEntry(bibtexEntry);
                        if (Globals.prefs.getBoolean("autoOpenForm")) {
                            object = this.panel.getEntryEditor(bibtexEntry);
                            this.panel.showEntryEditor((EntryEditor)object);
                            this.panel.adjustSplitter();
                        }
                        arrayList.add(bibtexEntry);
                        break;
                    }
                    case 3: {
                        BibtexEntryType bibtexEntryType;
                        DroppedFileHandler droppedFileHandler;
                        MetaDataListDialog metaDataListDialog = new MetaDataListDialog(string, true);
                        Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                        metaDataListDialog.showDialog();
                        Object object = metaDataListDialog.getXmlDocuments();
                        BibtexEntry bibtexEntry = null;
                        if (object != null && metaDataListDialog.getResult() == 0) {
                            int n3 = metaDataListDialog.getTableMetadata().getSelectedRow();
                            if (n3 > -1) {
                                String string2 = IdGenerator.next();
                                bibtexEntry = new BibtexEntry(string2);
                                if (this.fieldExists(((Document)object).getType())) {
                                    bibtexEntryType = BibtexEntryType.getStandardType(((Document)object).getType());
                                    if (bibtexEntryType == null) {
                                        bibtexEntryType = BibtexEntryTypes.ARTICLE;
                                    }
                                    bibtexEntry.setType(bibtexEntryType);
                                } else {
                                    bibtexEntry.setType(BibtexEntryTypes.ARTICLE);
                                }
                                ArrayList<BibtexEntry> arrayList2 = new ArrayList<BibtexEntry>();
                                arrayList2.add(bibtexEntry);
                                Util.setAutomaticFields(arrayList2, true, true, false);
                                this.insertFields(BibtexFields.getAllFieldNames(), bibtexEntry, (Document)object);
                                this.panel.database().insertEntry(bibtexEntry);
                                droppedFileHandler = new DroppedFileHandler(this.frame, this.panel);
                                droppedFileHandler.linkPdfToEntry(string, this.entryTable, bibtexEntry);
                                LabelPatternUtil.makeLabel(this.panel.metaData(), this.panel.database(), bibtexEntry);
                            } else {
                                bibtexEntry = this.createNewBlankEntry(string);
                            }
                        } else {
                            if (metaDataListDialog.getResult() == 2) break;
                            if (metaDataListDialog.getResult() == 1) {
                                bibtexEntry = this.createNewBlankEntry(string);
                            } else if (object == null && metaDataListDialog.getResult() == 0) {
                                bibtexEntry = this.createNewBlankEntry(string);
                            }
                        }
                        assert (bibtexEntry != null);
                        arrayList.add(bibtexEntry);
                        break;
                    }
                    case 0: {
                        BibtexEntry bibtexEntry = this.createNewBlankEntry(string);
                        arrayList.add(bibtexEntry);
                        break;
                    }
                    case 5: {
                        int n4;
                        BibtexEntryType bibtexEntryType;
                        MetaDataListDialog metaDataListDialog = new MetaDataListDialog(string, false);
                        Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                        metaDataListDialog.showDialog();
                        Object object = metaDataListDialog.getXmlDocuments();
                        if (object == null || metaDataListDialog.getResult() != 0 || (n4 = metaDataListDialog.getTableMetadata().getSelectedRow()) <= -1) break;
                        BibtexEntry bibtexEntry = this.entryTable.getEntryAt(this.dropRow);
                        if (this.fieldExists(((Document)object).getType()) && (bibtexEntryType = BibtexEntryType.getStandardType(((Document)object).getType())) != null) {
                            bibtexEntry.setType(bibtexEntryType);
                        }
                        this.insertFields(BibtexFields.getAllFieldNames(), bibtexEntry, (Document)object);
                        DroppedFileHandler droppedFileHandler = new DroppedFileHandler(this.frame, this.panel);
                        droppedFileHandler.linkPdfToEntry(string, this.entryTable, this.dropRow);
                        break;
                    }
                    case 4: {
                        DroppedFileHandler droppedFileHandler = new DroppedFileHandler(this.frame, this.panel);
                        droppedFileHandler.linkPdfToEntry(string, this.entryTable, this.dropRow);
                    }
                }
            }
        }
        return arrayList;
    }

    private BibtexEntry createNewBlankEntry(String string) {
        BibtexEntry bibtexEntry = this.createNewEntry();
        if (bibtexEntry != null) {
            DroppedFileHandler droppedFileHandler = new DroppedFileHandler(this.frame, this.panel);
            droppedFileHandler.linkPdfToEntry(string, this.entryTable, bibtexEntry);
        }
        return bibtexEntry;
    }

    private void insertFields(String[] stringArray, BibtexEntry bibtexEntry, Document document) {
        DocumentWrapper documentWrapper = new DocumentWrapper(document);
        for (String string : stringArray) {
            if (bibtexEntry.getField(string) != null) continue;
            if (string.equalsIgnoreCase("author")) {
                bibtexEntry.setField(string, documentWrapper.getAuthors("and"));
            }
            if (string.equalsIgnoreCase("title")) {
                bibtexEntry.setField(string, documentWrapper.getTitle());
            }
            if (string.equalsIgnoreCase("abstract")) {
                bibtexEntry.setField(string, documentWrapper.getAbstract());
            }
            if (string.equalsIgnoreCase("doi")) {
                bibtexEntry.setField(string, documentWrapper.getDoi());
            }
            if (!string.equalsIgnoreCase("year")) continue;
            bibtexEntry.setField(string, documentWrapper.getYear());
        }
    }

    private boolean fieldExists(String string) {
        return string != null && !string.isEmpty();
    }

    private BibtexEntry createNewEntry() {
        EntryTypeDialog entryTypeDialog = new EntryTypeDialog(this.frame);
        Util.placeDialog(entryTypeDialog, this.frame);
        entryTypeDialog.setVisible(true);
        BibtexEntryType bibtexEntryType = entryTypeDialog.getChoice();
        if (bibtexEntryType != null) {
            String string = IdGenerator.next();
            BibtexEntry bibtexEntry = new BibtexEntry(string, bibtexEntryType);
            try {
                this.panel.database().insertEntry(bibtexEntry);
                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
                arrayList.add(bibtexEntry);
                Util.setAutomaticFields(arrayList, true, true, false);
                this.panel.undoManager.addEdit(new UndoableInsertEntry(this.panel.database(), bibtexEntry, this.panel));
                this.panel.output(Globals.lang("Added new") + " '" + bibtexEntryType.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                if (this.panel.getMode() != 2) {
                    this.panel.setMode(3);
                }
                this.panel.showEntry(bibtexEntry);
                this.panel.markBaseChanged();
                new FocusRequester(this.panel.getEntryEditor(bibtexEntry));
                return bibtexEntry;
            }
            catch (KeyCollisionException keyCollisionException) {
                LOGGER.info("Key collision occured", keyCollisionException);
            }
        }
        return null;
    }

    private List<BibtexEntry> readXmpEntries(String string) {
        List<BibtexEntry> list = null;
        try {
            list = XMPUtil.readXMP(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private boolean hasXmpEntries(List<BibtexEntry> list) {
        return list != null && list.size() != 0;
    }

    public MainTable getEntryTable() {
        return this.entryTable;
    }

    public void setEntryTable(MainTable mainTable) {
        this.entryTable = mainTable;
    }

    public int getDropRow() {
        return this.dropRow;
    }

    public void setDropRow(int n) {
        this.dropRow = n;
    }

    public class ImportPdfFilesResult {
        public String[] noPdfFiles;
        public List<BibtexEntry> entries;
    }
}

