/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.components;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.business.actions.AutoLoadEnvironmentAction;
import org.pdfsam.guiclient.business.actions.LoadEnvironmentAction;
import org.pdfsam.guiclient.business.actions.SaveEnvironmentAction;
import org.pdfsam.guiclient.business.environment.Environment;
import org.pdfsam.guiclient.business.listeners.mediators.ApplicationExitMediator;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.configuration.GuiConfiguration;
import org.pdfsam.i18n.GettextResource;

public class JMainMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -818197133636053691L;
    private ApplicationExitMediator exitMediator;
    private JMenu recentMenu;

    public JMainMenuBar(SaveEnvironmentAction saveAction, LoadEnvironmentAction loadAction, ApplicationExitMediator exitMediator) {
        this.exitMediator = exitMediator;
        this.init(saveAction, loadAction);
    }

    private void init(SaveEnvironmentAction saveAction, LoadEnvironmentAction loadAction) {
        JMenu menuFile = new JMenu();
        menuFile.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File"));
        menuFile.setMnemonic(70);
        JMenuItem saveEnvItem = new JMenuItem();
        saveEnvItem.setAction(saveAction);
        JMenuItem loadEnvItem = new JMenuItem();
        loadEnvItem.setAction(loadAction);
        JMenuItem exitItem = new JMenuItem();
        exitItem.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Exit"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        exitItem.setActionCommand("saveAndExit");
        exitItem.setIcon(new ImageIcon(this.getClass().getResource("/images/exit.png")));
        exitItem.addActionListener(this.exitMediator);
        this.recentMenu = new JMenu(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Recent environments"));
        menuFile.add(saveEnvItem);
        menuFile.add(loadEnvItem);
        menuFile.addSeparator();
        menuFile.add(this.recentMenu);
        menuFile.addSeparator();
        menuFile.add(exitItem);
        this.add(menuFile);
    }

    public void rebuildRecentEnvironmentSubmenu(Environment environment) {
        this.recentMenu.removeAll();
        for (String recentEnv : GuiConfiguration.getInstance().getRecentEnvironments()) {
            this.recentMenu.add(new JMenuItem(new AutoLoadEnvironmentAction(environment, new File(recentEnv))));
        }
        this.recentMenu.repaint();
    }
}

