/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeStruct;
import de.intarsys.nativec.type.NativeStructType;

public class StructMember {
    private final INativeType memberType;
    protected final String name;
    protected final int index;
    private final int offset;
    private final NativeStructType structType;

    protected StructMember(NativeStructType nativeStructType, String string, int n, INativeType iNativeType, int n2) {
        this.structType = nativeStructType;
        this.name = string;
        this.index = n;
        this.memberType = iNativeType;
        this.offset = n2;
    }

    public byte getByte(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getByte(this.offset + n);
    }

    public byte[] getByteArray(NativeStruct nativeStruct, int n, int n2) {
        return nativeStruct.handle.getByteArray(this.offset + n, n2);
    }

    public long getCLong(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getCLong(this.offset + n);
    }

    public int getInt(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getInt(this.offset + n);
    }

    public long getLong(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getLong(this.offset + n);
    }

    protected INativeType getMemberType() {
        return this.memberType;
    }

    public String getName() {
        return this.name;
    }

    public INativeHandle getNativeHandle(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getNativeHandle(this.offset + n);
    }

    public synchronized INativeObject getNativeObject(NativeStruct nativeStruct) {
        INativeObject iNativeObject;
        if (nativeStruct.values == null) {
            nativeStruct.values = new INativeObject[this.structType.getFieldsSize()];
        }
        if ((iNativeObject = nativeStruct.values[this.index]) == null) {
            nativeStruct.values[this.index] = iNativeObject = this.memberType.createNative(nativeStruct.getNativeHandle().offset(this.offset));
        }
        return iNativeObject;
    }

    protected int getOffset() {
        return this.offset;
    }

    public short getShort(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getShort(this.offset + n);
    }

    public String getString(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getString(this.offset + n);
    }

    public Object getValue(NativeStruct nativeStruct) {
        return this.getNativeObject(nativeStruct).getValue();
    }

    public String getWideString(NativeStruct nativeStruct, int n) {
        return nativeStruct.handle.getWideString(this.offset + n);
    }

    public void setByte(NativeStruct nativeStruct, int n, byte by) {
        nativeStruct.handle.setByte(this.offset + n, by);
    }

    public void setByteArray(NativeStruct nativeStruct, int n, byte[] byArray, int n2, int n3) {
        nativeStruct.handle.setByteArray(this.offset + n, byArray, n2, n3);
    }

    public void setCLong(NativeStruct nativeStruct, int n, long l) {
        nativeStruct.handle.setCLong(this.offset + n, l);
    }

    public void setInt(NativeStruct nativeStruct, int n, int n2) {
        nativeStruct.handle.setInt(this.offset + n, n2);
    }

    public void setLong(NativeStruct nativeStruct, int n, long l) {
        nativeStruct.handle.setLong(this.offset + n, l);
    }

    public void setNativeHandle(NativeStruct nativeStruct, int n, INativeHandle iNativeHandle) {
        nativeStruct.handle.setNativeHandle(this.offset + n, iNativeHandle);
    }

    public void setShort(NativeStruct nativeStruct, int n, short s) {
        nativeStruct.handle.setShort(this.offset + n, s);
    }

    public void setString(NativeStruct nativeStruct, int n, String string) {
        nativeStruct.handle.setString(this.offset + n, string);
    }

    public void setValue(NativeStruct nativeStruct, Object object) {
        this.getNativeObject(nativeStruct).setValue(object);
    }

    public void setWideString(NativeStruct nativeStruct, int n, String string) {
        nativeStruct.handle.setWideString(this.offset + n, string);
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

