/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.Transition;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class SlideShowParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = 498418601794673447L;
    public static final String F_ARG = "f";
    public static final String P_ARG = "p";
    public static final String O_ARG = "o";
    public static final String L_ARG = "l";
    public static final String T_ARG = "t";
    public static final String DT_ARG = "dt";
    public static final String FULLSCREEN_ARG = "fullscreen";
    private File outputFile;
    private PdfFile inputFile;
    private boolean fullScreen = false;
    private Transition defaultTransition;
    private Transition[] transitions;
    private File inputXmlFile;
    private String outputFilesPrefix = "";

    public SlideShowParsedCommand() {
    }

    public SlideShowParsedCommand(File outputFile, PdfFile inputFile, boolean fullScreen, Transition defaultTransition, Transition[] transitions, File inputXmlFile) {
        this.outputFile = outputFile;
        this.inputFile = inputFile;
        this.fullScreen = fullScreen;
        this.defaultTransition = defaultTransition;
        this.transitions = transitions;
        this.inputXmlFile = inputXmlFile;
    }

    public SlideShowParsedCommand(File outputFile, PdfFile inputFile, boolean fullScreen, Transition defaultTransition, Transition[] transitions, File inputXmlFile, boolean overwrite, boolean compress, File logFile, char outputPdfVersion) {
        super(overwrite, compress, logFile, outputPdfVersion);
        this.outputFile = outputFile;
        this.inputFile = inputFile;
        this.fullScreen = fullScreen;
        this.defaultTransition = defaultTransition;
        this.transitions = transitions;
        this.inputXmlFile = inputXmlFile;
    }

    public SlideShowParsedCommand(File outputFile, PdfFile inputFile, boolean fullScreen, Transition defaultTransition, Transition[] transitions, File inputXmlFile, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.outputFile = outputFile;
        this.inputFile = inputFile;
        this.fullScreen = fullScreen;
        this.defaultTransition = defaultTransition;
        this.transitions = transitions;
        this.inputXmlFile = inputXmlFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public PdfFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(PdfFile inputFile) {
        this.inputFile = inputFile;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public Transition getDefaultTransition() {
        return this.defaultTransition;
    }

    public void setDefaultTransition(Transition defaultTransition) {
        this.defaultTransition = defaultTransition;
    }

    public Transition[] getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Transition[] transitions) {
        this.transitions = transitions;
    }

    public File getInputXmlFile() {
        return this.inputXmlFile;
    }

    public void setInputXmlFile(File inputXmlFile) {
        this.inputXmlFile = inputXmlFile;
    }

    public String getCommand() {
        return "slideshow";
    }

    public String getOutputFilesPrefix() {
        return this.outputFilesPrefix;
    }

    public void setOutputFilesPrefix(String outputFilesPrefix) {
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputFile=" + this.outputFile.getAbsolutePath() + "]");
        retVal.append(this.inputFile == null ? "" : "[outputFile=" + this.outputFile.getAbsolutePath() + "]");
        if (this.transitions != null) {
            retVal.append("[transitions.length=" + this.transitions.length + "]");
        }
        retVal.append("[defaultTransition=" + this.defaultTransition + "]");
        retVal.append("[fullScreen=" + this.fullScreen + "]");
        retVal.append("[inputXmlFile=" + this.inputXmlFile + "]");
        retVal.append("[outputFilesPrefix=" + this.outputFilesPrefix + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

