/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class NestedIterator
implements Iterator {
    private Iterator innerIterator = null;
    private Object outerCurrent;
    private Iterator outerIterator = null;
    private boolean tryInner = true;

    public NestedIterator(Iterator iterator) {
        this.setOuterIterator(iterator);
    }

    public NestedIterator(List list) {
        this.setOuterIterator(list.iterator());
    }

    protected void createInnerIterator() {
        this.setInnerIterator(null);
        if (this.getOuterCurrent() != null) {
            if (this.getOuterCurrent() instanceof List) {
                this.setInnerIterator(new NestedIterator(((List)this.getOuterCurrent()).iterator()));
            }
            if (this.getOuterCurrent() instanceof Iterable) {
                this.setInnerIterator(new NestedIterator(((Iterable)this.getOuterCurrent()).iterator()));
            }
            if (this.getOuterCurrent() instanceof Iterator) {
                this.setInnerIterator(new NestedIterator((Iterator)this.getOuterCurrent()));
            }
        }
    }

    protected Iterator getInnerIterator() {
        return this.innerIterator;
    }

    protected Object getOuterCurrent() {
        return this.outerCurrent;
    }

    protected Iterator getOuterIterator() {
        return this.outerIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.isTryInner()) {
            if (!this.getOuterIterator().hasNext()) {
                return false;
            }
            this.setTryInner(false);
            this.setOuterCurrent(this.getOuterIterator().next());
            this.createInnerIterator();
        }
        if (this.getInnerIterator() == null) {
            return true;
        }
        if (this.getInnerIterator().hasNext()) {
            return true;
        }
        this.setTryInner(true);
        return this.hasNext();
    }

    private boolean isTryInner() {
        return this.tryInner;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more elements");
        }
        if (this.getInnerIterator() == null) {
            this.setTryInner(true);
            return this.getOuterCurrent();
        }
        return this.getInnerIterator().next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("iterator not modifiable");
    }

    private void setInnerIterator(Iterator iterator) {
        this.innerIterator = iterator;
    }

    private void setOuterCurrent(Object object) {
        this.outerCurrent = object;
    }

    private void setOuterIterator(Iterator iterator) {
        this.outerIterator = iterator;
    }

    private void setTryInner(boolean bl) {
        this.tryInner = bl;
    }
}

