/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class TransientLocator
extends CommonLocator {
    private boolean alwaysUnchanged;
    private String localName;
    private String type;

    public TransientLocator(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("name and type may not be null for TransientLocator");
        }
        this.localName = string;
        this.type = this.canonical(string2);
    }

    private String canonical(String string) {
        return string.trim().toLowerCase();
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public ILocator getChild(String string) {
        return null;
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader(String string) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public boolean isAlwaysUnchanged() {
        return this.alwaysUnchanged;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String string) throws IOException {
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string);
    }

    public void setAlwaysUnchanged(boolean bl) {
        this.alwaysUnchanged = bl;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

