/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class DocInfoOption
implements CommandOption {
    public Map<String, String> docinfo = new HashMap<String, String>();

    public boolean supportsOption(String string) {
        return string.equals("-docinfo");
    }

    public boolean setOption(String string, String string2) {
        int n = string2.indexOf("=");
        if (n == -1) {
            System.err.println("Missing equals sign in -docinfo value: " + string2);
            return false;
        }
        this.docinfo.put(string2.substring(0, n), string2.substring(n + 1));
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.docinfo.size() > 0) {
            pdfTweak.updateInfoDictionary(this.docinfo);
        }
    }

    public String getSummary() {
        return " -docinfo                Change document info\n";
    }

    public String getHelp(String string) {
        return " -docinfo {NAME}={VALUE}\n    Set {NAME} to {VALUE} in document info.";
    }
}

