/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.core.ViewerPreference;

public class ViewerOptions
implements CommandOption {
    private int pagemode = -1;
    private int pagelayout = -1;
    private Map<PdfName, PdfObject> optionalPrefs = new HashMap<PdfName, PdfObject>();

    public boolean supportsOption(String string) {
        return string.equals("-pagemode") || string.equals("-pagelayout") || string.equals("-viewpref");
    }

    public boolean setOption(String string, String string2) {
        if (string.equals("-pagemode")) {
            this.pagemode = Arrays.asList("None", "Outline", "Thumbnails", "Full_Screen", "Optional_Content", "Attachments").indexOf(string2);
            if (this.pagemode == -1) {
                System.err.println("Invalid page mode: " + string2);
                return false;
            }
        } else if (string.equals("-pagelayout")) {
            this.pagelayout = Arrays.asList("Single_Page", "One_Column", "Two_Columns_Left", "Two_Columns_Right", "Two_Pages_Left", "Two_Pages_Right").indexOf(string2);
            if (this.pagelayout == -1) {
                System.err.println("Invalid page layout: " + string2);
                return false;
            }
        } else if (string.equals("-viewpref")) {
            int n = string2.indexOf(61);
            if (n == -1) {
                System.err.println("Invalid viewer preference: " + string2);
                return false;
            }
            String string3 = string2.substring(0, n).replace('_', ' ');
            String string4 = string2.substring(n + 1);
            for (ViewerPreference viewerPreference : ViewerPreference.SUPPORTED_VIEWER_PREFERENCES) {
                if (!viewerPreference.getName().equals(string3)) continue;
                for (PdfObject pdfObject : viewerPreference.getPossibleValues()) {
                    if (!pdfObject.toString().equals(string4)) continue;
                    this.optionalPrefs.put(viewerPreference.getInternalName(), pdfObject);
                    return true;
                }
            }
            System.err.println("Invalid viewer preference: " + string2);
            return false;
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.pagemode != -1 || this.pagelayout != -1 || this.optionalPrefs.size() > 0) {
            if (this.pagemode == -1) {
                this.pagemode = 0;
            }
            if (this.pagelayout == -1) {
                this.pagelayout = 0;
            }
            int n = (64 << this.pagemode) + (1 << this.pagelayout);
            pdfTweak.setViewerPreferences(n, this.optionalPrefs);
        }
    }

    public String getSummary() {
        return " -pagemode               Set page mode (viewer preference)\n -pagelayout             Set page layout (viewer preference)\n -viewpref               Set additional viewer preferences\n";
    }

    public String getHelp(String string) {
        return " -pagemode {PAGEMODE}\n -pagelayout {PAGELAYOUT}\n -viewpref {NAME}={VALUE}\n    Set viewer preferences. Names and values are like in the GUI,\n    except that spaces are replaced by underscores.";
    }
}

