/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShuffleRule {
    private final boolean newPageBefore;
    private final PageBase pageBase;
    private final int pageNumber;
    private final char rotate;
    private final double scale;
    private final double offsetX;
    private final boolean offsetXPercent;
    private final double offsetY;
    private final boolean offsetYPercent;
    private final double frameWidth;
    public static final String[] predefinedRuleSets = new String[]{"1:!+1N1+0%+0%=Default", "1:!-1N1+0%+0%=Reverse Page Order", "2:!+1L0.707+0%-100%,+2L.707+100%-100%=2-up Portrait", "2:!+1L0.707+0%-100%,+2L.707+0%-200%=2-up Landscape", "4:!+1N0.5+0%+100%,+2N0.5+100%+100%,+3N0.5+0%+0%,+4N0.5+100%+0%,=4-up", "9:!+1N.333+0%+200%,+2N.333+100%+200%,+3N.333+200%+200%,+4N.333+0%+100%,+5N.333+100%+100%,+6N.333+200%+100%,+7N.333+0%+0%,+8N.333+100%+0%,+9N.333+200%+0%,=9-up", "-4:!-4N1+0%+0%,!+1N1+0%+0%,!+2N1+0%+0%,!-3N1+0%+0%=Booklet Reorder", "-4:!-4L0.707+0%-100%,+1L.707+100%-100%,!+2L0.707+0%-100%,-3L.707+100%-100%=Booklet Portrait", "-4:!-4L0.707+0%-100%,+1L.707+0%-200%,!+2L0.707+0%-100%,-3L.707+0%-200%=Booklet Landscape", "4:!-4N0.5+0%+100%,+1N0.5+100%+100%,+2U0.5-200%-100%,-3U0.5-100%-100%=Booklet 2-Up Fold", "-8:!-8N0.5+0%+100%,+1N0.5+100%+100%,-6N0.5+0%+0%,+3N0.5+100%+0%,!+2N0.5+0%+100%,-7N0.5+100%+100%,+4N0.5+0%+0%,-5N0.5+100%+0%=Booklet 2-Up Cut", "8:!+1L0.353+300%-100%,+2R0.353-400%+100%,+3R0.353-300%+100%,+4R0.353-200%+100%,+5R0.353-100%+100%,+6L0.353+0%-100%,+7L0.353+100%-100%,+8L0.353+200%-100%=PocketMod", "8:!+1L0.353+300%-200%,+2R0.353-400%+0%,+3R0.353-300%+0%,+4R0.353-200%+0%,+5R0.353-100%+0%,+6L0.353+0%-200%,+7L0.353+100%-200%,+8L0.353+200%-200%=PocketMod UpsideDown", "1:!+1N0.25+150%+300%,+1L0.25+250%-100%,+1U0.25-250%-100%,+1R0.25-350%+183%=Star Test Pattern", "2:!+1L0.707+0%-100%,+1L.707+100%-100%=Tile Copy 2x1", "4:!+1N0.5+0%+100%,+1N0.5+100%+100%,+1N0.5+0%+0%,+1N0.5+100%+0%=Tile Copy 2x2", "8:!+1L0.3535+0%-100%,+1L0.3535+0%-200%,+1L0.3535+100%-100%,+1L0.3535+100%-200%,+1L0.3535+200%-100%,+1L0.3535+200%-200%,+1L0.3535+300%-100%,+1L0.3535+300%-200%,=Tile Copy 4x2", "9:!+1N0.333+0.0%+200.0%,+1N0.333+100.0%+200.0%,+1N0.333+200.0%+200.0%,+1N0.333+0.0%+100.0%,+1N0.333+100.0%+100.0%,+1N0.333+200.0%+100.0%,+1N0.333+0.0%+0.0%,+1N0.333+100.0%+0.0%,+1N0.333+200.0%+0.0%=Tile Copy 3x3", "16:!+1N0.25+0%+300%,+1N0.25+100%+300%,+1N0.25+200%+300%,+1N0.25+300%+300%,+1N0.25+0%+200%,+1N0.25+100%+200%,+1N0.25+200%+200%,+1N0.25+300%+200%,+1N0.25+0%+100%,+1N0.25+100%+100%,+1N0.25+200%+100%,+1N0.25+300%+100%,+1N0.25+0%+0%,+1N0.25+100%+0%,+1N0.25+200%+0%,+1N0.25+300%+0%=Tile Copy 4x4", "32:!+1L0.17675+0%-100%,+1L0.17675+0%-200%,+1L0.17675+100%-100%,+1L0.17675+100%-200%,+1L0.17675+200%-100%,+1L0.17675+200%-200%,+1L0.17675+300%-100%,+1L0.17675+300%-200%,+1L0.17675+400%-100%,+1L0.17675+400%-200%,+1L0.17675+500%-100%,+1L0.17675+500%-200%,+1L0.17675+600%-100%,+1L0.17675+600%-200%,+1L0.17675+700%-100%,+1L0.17675+700%-200%,+1L0.17675+0%-300%,+1L0.17675+0%-400%,+1L0.17675+100%-300%,+1L0.17675+100%-400%,+1L0.17675+200%-300%,+1L0.17675+200%-400%,+1L0.17675+300%-300%,+1L0.17675+300%-400%,+1L0.17675+400%-300%,+1L0.17675+400%-400%,+1L0.17675+500%-300%,+1L0.17675+500%-400%,+1L0.17675+600%-300%,+1L0.17675+600%-400%,+1L0.17675+700%-300%,+1L0.17675+700%-400%=Tile Copy 4x8", "1:!+1N2.0+0.0%-25.0%,!+1N2.0-50.0%-25.0%=Split 2-up Landscape (Scale to Portrait first)"};

    public ShuffleRule(boolean bl, PageBase pageBase, int n, char c, double d, double d2, boolean bl2, double d3, boolean bl3, double d4) {
        if ("NRLU".indexOf(c) == -1) {
            throw new IllegalArgumentException("" + c);
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.newPageBefore = bl;
        this.pageBase = pageBase;
        this.pageNumber = n;
        this.rotate = c;
        this.scale = d;
        this.offsetX = d2;
        this.offsetXPercent = bl2;
        this.offsetY = d3;
        this.offsetYPercent = bl3;
        this.frameWidth = d4;
    }

    public boolean isNewPageBefore() {
        return this.newPageBefore;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public boolean isOffsetXPercent() {
        return this.offsetXPercent;
    }

    public String getOffsetXString() {
        String string = this.offsetX + (this.offsetXPercent ? "%" : "");
        if (!string.startsWith("-")) {
            string = "+" + string;
        }
        return string;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public boolean isOffsetYPercent() {
        return this.offsetYPercent;
    }

    public String getOffsetYString() {
        String string = this.offsetY + (this.offsetYPercent ? "%" : "");
        if (!string.startsWith("-")) {
            string = "+" + string;
        }
        return string;
    }

    public PageBase getPageBase() {
        return this.pageBase;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public String getPageString() {
        return (this.pageBase == PageBase.ABSOLUTE ? "" : (this.pageBase == PageBase.BEGINNING ? "+" : "-")) + this.pageNumber;
    }

    public char getRotate() {
        return this.rotate;
    }

    public double getScale() {
        return this.scale;
    }

    public String toString() {
        return (this.newPageBefore ? "!" : "") + this.getPageString() + this.rotate + this.scale + this.getOffsetXString() + this.getOffsetYString() + (this.frameWidth == 0.0 ? "" : "F" + this.frameWidth);
    }

    public static ShuffleRule parseRule(String string) {
        Pattern pattern = Pattern.compile("(\\!?)([-+]?)([0-9]+)([NRLU])([0-9.]+)([+-][0-9.]+)(%?)([+-][0-9.]+)(%?)((F[0-9.]+)?)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new NumberFormatException(string);
        }
        return new ShuffleRule(matcher.group(1).length() == 1, matcher.group(2).length() == 0 ? PageBase.ABSOLUTE : (matcher.group(2).charAt(0) == '+' ? PageBase.BEGINNING : PageBase.END), Integer.parseInt(matcher.group(3)), matcher.group(4).charAt(0), Double.parseDouble(matcher.group(5)), Double.parseDouble(matcher.group(6)), matcher.group(7).length() == 1, Double.parseDouble(matcher.group(8)), matcher.group(9).length() == 1, matcher.group(10).length() == 0 ? 0.0 : Double.parseDouble(matcher.group(11).substring(1)));
    }

    public int getRotateAngle() {
        switch (this.rotate) {
            case 'N': {
                return 0;
            }
            case 'R': {
                return 90;
            }
            case 'U': {
                return 180;
            }
            case 'L': {
                return 270;
            }
        }
        throw new IllegalStateException();
    }

    public static ShuffleRule[] parseRuleSet(String string, int[] nArray) {
        int n = string.indexOf(":");
        if (n == -1) {
            throw new NumberFormatException("No colon found");
        }
        int n2 = string.indexOf(44);
        if (n2 == -1 || n2 > n) {
            n2 = n;
        }
        int n3 = Integer.parseInt(string.substring(0, n2));
        int n4 = n2 == n ? 0 : Integer.parseInt(string.substring(n2 + 1, n));
        String[] stringArray = string.substring(n + 1).split(",");
        ShuffleRule[] shuffleRuleArray = new ShuffleRule[stringArray.length];
        for (int i = 0; i < shuffleRuleArray.length; ++i) {
            shuffleRuleArray[i] = ShuffleRule.parseRule(stringArray[i]);
        }
        if (shuffleRuleArray.length == 0) {
            throw new NumberFormatException("No rules found");
        }
        if (!shuffleRuleArray[0].isNewPageBefore()) {
            throw new NumberFormatException("First rule must have new page before");
        }
        nArray[0] = n3;
        nArray[1] = n4;
        return shuffleRuleArray;
    }

    public double getFrameWidth() {
        return this.frameWidth;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageBase {
        ABSOLUTE,
        BEGINNING,
        END;

    }
}

