/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import jpdftweak.core.PageDimension;
import jpdftweak.core.ShuffleRule;

public class PreviewPanel
extends JPanel {
    private float pwidth = 1.0f;
    private float pheight = 1.0f;
    private ShuffleRule[] rules = new ShuffleRule[0];

    public void setConfig(ShuffleRule[] shuffleRuleArray) {
        this.rules = shuffleRuleArray;
        this.repaint();
    }

    public void setPageFormat(PageDimension pageDimension) {
        this.pwidth = pageDimension.getWidth();
        this.pheight = pageDimension.getHeight();
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setFont(new Font("Dialog", 0, 20));
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth() - 10;
        int n2 = (int)((float)n * this.pheight / this.pwidth);
        int n3 = -n2;
        for (ShuffleRule shuffleRule : this.rules) {
            if (shuffleRule.isNewPageBefore()) {
                graphics.setColor(Color.WHITE);
                graphics.fillRect(4, (n3 += n2 + 5) - 1, n + 2, n2 + 2);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(4, n3 - 1, n + 2, n2 + 2);
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics.translate(5, n3 + n2);
            graphics2D.rotate(Math.toRadians(shuffleRule.getRotateAngle()));
            double d = shuffleRule.getOffsetX();
            double d2 = shuffleRule.getOffsetY();
            d = shuffleRule.isOffsetXPercent() ? d * (double)n / 100.0 : d * (double)n / (double)this.pwidth;
            d2 = shuffleRule.isOffsetYPercent() ? d2 * (double)n2 / 100.0 : d2 * (double)n2 / (double)this.pheight;
            graphics2D.scale(shuffleRule.getScale(), shuffleRule.getScale());
            graphics2D.translate(d, -d2);
            graphics.setColor(Color.YELLOW);
            graphics.fillRect(0, -n2, n, n2);
            graphics.setColor(Color.BLUE);
            graphics.drawRect(0, -n2, n, n2);
            graphics.drawString(shuffleRule.getPageString(), 5, -n2 + 20);
            graphics2D.setTransform(affineTransform);
        }
    }
}

