/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.Tab;

public class DocumentInfoTab
extends Tab {
    private final MainForm mainForm;
    private JCheckBox infoChange;
    private TableComponent infoEntries;
    private JButton infoLoad;
    private JButton infoAdd;

    public DocumentInfoTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p:g, f:p", "f:p, f:p, f:p:g"));
        this.mainForm = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.infoChange = new JCheckBox("Change Document Info");
        this.add((Component)this.infoChange, cellConstraints.xy(1, 1));
        this.infoChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DocumentInfoTab.this.infoChange.isSelected();
                DocumentInfoTab.this.infoLoad.setEnabled(bl);
                DocumentInfoTab.this.infoAdd.setEnabled(bl);
                DocumentInfoTab.this.infoEntries.setEnabled(bl);
            }
        });
        this.infoLoad = new JButton("Load from document");
        this.add((Component)this.infoLoad, cellConstraints.xy(2, 1));
        this.infoLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentInfoTab.this.infoEntries.clear();
                if (DocumentInfoTab.this.mainForm.getInputFile() == null) {
                    return;
                }
                Map<String, String> map = DocumentInfoTab.this.mainForm.getInputFile().getInfoDictionary();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    DocumentInfoTab.this.infoEntries.addRow(entry.getKey(), entry.getValue());
                }
            }
        });
        this.infoAdd = new JButton("Add predefined...");
        this.add((Component)this.infoAdd, cellConstraints.xyw(1, 2, 2));
        this.infoAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (String string : PdfTweak.getKnownInfoNames()) {
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = ((JMenuItem)actionEvent.getSource()).getText();
                            DocumentInfoTab.this.infoEntries.addRow(string, "");
                        }
                    });
                }
                jPopupMenu.show(DocumentInfoTab.this.infoAdd, 0, DocumentInfoTab.this.infoAdd.getHeight());
            }
        });
        this.infoEntries = new TableComponent(new String[]{"Name", "Value"}, new Class[]{String.class, String.class}, new Object[]{"", ""});
        this.add((Component)this.infoEntries, cellConstraints.xyw(1, 3, 2));
        this.infoLoad.setEnabled(false);
        this.infoAdd.setEnabled(false);
        this.infoEntries.setEnabled(false);
    }

    public String getTabName() {
        return "Document Info";
    }

    public PdfTweak run(PdfTweak pdfTweak) {
        if (this.infoChange.isSelected()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < this.infoEntries.getRowCount(); ++i) {
                Object[] objectArray = this.infoEntries.getRow(i);
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                hashMap.put(string, string2);
            }
            pdfTweak.updateInfoDictionary(hashMap);
        }
        return pdfTweak;
    }
}

