/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jpdftweak.core.PdfToImage;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.tabs.Tab;

public class OutputTab
extends Tab {
    private JTextField outputFile;
    private JSlider qualitySlider;
    private JCheckBox burst;
    private JCheckBox multipageTiff;
    private JCheckBox transparent;
    private JCheckBox uncompressed;
    private JCheckBox pageMarks;
    private JCheckBox tempfiles;
    private JCheckBox optimizeSize;
    private JCheckBox fullyCompressed;
    private JLabel colorLabel;
    private JLabel compressionLabel;
    private JLabel qualityLabel;
    private JLabel warning;
    private JComboBox fileType;
    private JComboBox colorMode;
    private JComboBox compressionType;
    private JPanel imagePanel;
    private final MainForm mainForm;

    public OutputTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p, f:p:g, f:p", "f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p:g"));
        this.mainForm = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.add((Component)new JLabel("Filename:"), cellConstraints.xy(1, 1));
        this.outputFile = new JTextField("");
        this.add((Component)this.outputFile, cellConstraints.xy(2, 1));
        JButton jButton = new JButton("...");
        this.add((Component)jButton, cellConstraints.xy(3, 1));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = OutputTab.this.mainForm.getPdfChooser();
                if (jFileChooser.showSaveDialog(OutputTab.this.mainForm) != 0) {
                    return;
                }
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                if (new File(string = OutputTab.this.setCorrectExtension(string)).exists() && JOptionPane.showConfirmDialog(OutputTab.this.mainForm, "Overwrite existing file?", "Confirm Overwrite", 0, 3) == 1) {
                    return;
                }
                OutputTab.this.outputFile.setText(string);
            }
        });
        this.multipageTiff = new JCheckBox("Export as Tiff multipage image");
        this.add((Component)this.multipageTiff, cellConstraints.xyw(1, 2, 3));
        this.multipageTiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputTab.this.findSharedLibrary();
                OutputTab.this.fileType.setEnabled(false);
                OutputTab.this.burst.setSelected(false);
                if (!OutputTab.this.multipageTiff.isSelected()) {
                    OutputTab.this.whichToEnable(0);
                } else {
                    OutputTab.this.whichToEnable(100);
                }
                String string = OutputTab.this.outputFile.getText();
                string = OutputTab.this.setCorrectExtension(string);
                OutputTab.this.outputFile.setText(string);
            }
        });
        this.burst = new JCheckBox("Burst pages (use * in file name as wildcard for page number)");
        this.add((Component)this.burst, cellConstraints.xyw(1, 3, 3));
        this.burst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputTab.this.multipageTiff.setSelected(false);
                OutputTab.this.fileType.setEnabled(OutputTab.this.burst.isSelected());
                OutputTab.this.warning.setIcon(null);
                OutputTab.this.warning.setToolTipText("");
                if (!OutputTab.this.burst.isSelected() && !OutputTab.this.multipageTiff.isSelected()) {
                    OutputTab.this.whichToEnable(0);
                } else {
                    OutputTab.this.whichToEnable(OutputTab.this.fileType.getSelectedIndex());
                    if (OutputTab.this.fileType.getSelectedIndex() != 0) {
                        OutputTab.this.findSharedLibrary();
                    }
                }
                String string = OutputTab.this.outputFile.getText();
                string = OutputTab.this.setCorrectExtension(string);
                OutputTab.this.outputFile.setText(string);
            }
        });
        this.add((Component)new JLabel("Type:"), cellConstraints.xy(1, 4));
        this.fileType = new JComboBox<PdfToImage.ImageType>(new DefaultComboBoxModel<PdfToImage.ImageType>(new PdfToImage.ImageType[]{PdfToImage.ImageType.PDF, PdfToImage.ImageType.JPG, PdfToImage.ImageType.PNG, PdfToImage.ImageType.GIF, PdfToImage.ImageType.PAM, PdfToImage.ImageType.PNM, PdfToImage.ImageType.BMP, PdfToImage.ImageType.TIFF}));
        this.add(this.fileType, cellConstraints.xyw(2, 4, 2));
        this.fileType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OutputTab.this.whichToEnable(OutputTab.this.fileType.getSelectedIndex());
                if (OutputTab.this.fileType.getSelectedIndex() == 0) {
                    OutputTab.this.setOptionsEnabled(false, false, false, false, true);
                    if (OutputTab.this.warning.getToolTipText().equals("<html>Images will be exported in 72 dpi")) {
                        OutputTab.this.warning.setIcon(null);
                        OutputTab.this.warning.setToolTipText("");
                    }
                } else {
                    OutputTab.this.findSharedLibrary();
                }
                String string = OutputTab.this.outputFile.getText();
                string = OutputTab.this.setCorrectExtension(string);
                OutputTab.this.outputFile.setText(string);
            }
        });
        this.fileType.setEnabled(false);
        this.imagePanel = new JPanel((LayoutManager)new FormLayout("f:p, f:p:g, f:p", "f:p, f:p, f:p, 30px"));
        this.add((Component)this.imagePanel, cellConstraints.xyw(1, 5, 3));
        this.colorLabel = new JLabel("Color Mode:");
        this.imagePanel.add((Component)this.colorLabel, cellConstraints.xy(1, 1));
        this.colorMode = new JComboBox<PdfToImage.ColorMode>(new DefaultComboBoxModel<PdfToImage.ColorMode>(new PdfToImage.ColorMode[]{PdfToImage.ColorMode.RGB, PdfToImage.ColorMode.GRAY, PdfToImage.ColorMode.BNW, PdfToImage.ColorMode.BNWI}));
        this.imagePanel.add(this.colorMode, cellConstraints.xyw(2, 1, 2));
        this.colorMode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (OutputTab.this.fileType.getSelectedIndex() == 7 || OutputTab.this.multipageTiff.isSelected()) {
                    PdfToImage.ColorMode colorMode = (PdfToImage.ColorMode)((Object)OutputTab.this.colorMode.getSelectedItem());
                    switch (colorMode) {
                        case GRAY: {
                            OutputTab.this.transparent.setEnabled(false);
                            break;
                        }
                        case BNW: {
                            OutputTab.this.transparent.setEnabled(false);
                            break;
                        }
                        case BNWI: {
                            OutputTab.this.transparent.setEnabled(false);
                            break;
                        }
                        default: {
                            OutputTab.this.transparent.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.compressionLabel = new JLabel("Compression:");
        this.imagePanel.add((Component)this.compressionLabel, cellConstraints.xy(1, 2));
        this.compressionType = new JComboBox<PdfToImage.TiffCompression>(new DefaultComboBoxModel<PdfToImage.TiffCompression>(new PdfToImage.TiffCompression[]{PdfToImage.TiffCompression.NONE, PdfToImage.TiffCompression.LZW, PdfToImage.TiffCompression.JPEG, PdfToImage.TiffCompression.ZLIB, PdfToImage.TiffCompression.PACKBITS, PdfToImage.TiffCompression.DEFLATE}));
        this.imagePanel.add(this.compressionType, cellConstraints.xyw(2, 2, 2));
        this.compressionType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PdfToImage.TiffCompression tiffCompression = (PdfToImage.TiffCompression)((Object)OutputTab.this.compressionType.getSelectedItem());
                switch (tiffCompression) {
                    case JPEG: {
                        OutputTab.this.setOptionsEnabled(true, true, true, OutputTab.this.colorMode.getSelectedIndex() == 0, false);
                        break;
                    }
                    case ZLIB: {
                        OutputTab.this.setOptionsEnabled(true, true, true, OutputTab.this.colorMode.getSelectedIndex() == 0, false);
                        break;
                    }
                    default: {
                        OutputTab.this.setOptionsEnabled(true, true, false, OutputTab.this.colorMode.getSelectedIndex() == 0, false);
                    }
                }
            }
        });
        this.qualityLabel = new JLabel("Quality:");
        this.imagePanel.add((Component)this.qualityLabel, cellConstraints.xy(1, 3));
        this.qualitySlider = new JSlider();
        this.imagePanel.add((Component)this.qualitySlider, cellConstraints.xyw(2, 3, 2));
        this.qualitySlider.setValue(100);
        this.transparent = new JCheckBox("Save transparency of image background");
        this.imagePanel.add((Component)this.transparent, cellConstraints.xyw(1, 4, 2));
        this.warning = new JLabel("");
        this.imagePanel.add((Component)this.warning, cellConstraints.xy(3, 4));
        this.imagePanel.setBorder(new TitledBorder("Burst as Image Options"));
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 6, 3));
        this.uncompressed = new JCheckBox("Save uncompressed");
        this.add((Component)this.uncompressed, cellConstraints.xyw(1, 7, 3));
        this.pageMarks = new JCheckBox("Remove PdfTk page marks");
        this.add((Component)this.pageMarks, cellConstraints.xyw(1, 8, 3));
        this.uncompressed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputTab.this.pageMarks.setText((OutputTab.this.uncompressed.isSelected() ? "Add" : "Remove") + " PdfTk page marks");
            }
        });
        this.tempfiles = new JCheckBox("Use temporary files for intermediary results (saves RAM)");
        this.add((Component)this.tempfiles, cellConstraints.xyw(1, 9, 3));
        this.optimizeSize = new JCheckBox("Optimize PDF size (will need a lot of RAM)");
        this.add((Component)this.optimizeSize, cellConstraints.xyw(1, 10, 3));
        this.fullyCompressed = new JCheckBox("Use better compression (Acrobat 6.0)");
        this.add((Component)this.fullyCompressed, cellConstraints.xyw(1, 11, 3));
        this.add((Component)new JLabel("<html>You can use the following variables in the output filename:<br><tt>&lt;F></tt>: Input filename without extension<br><tt>&lt;FX></tt>: Input filename with extension<br><tt>&lt;P></tt>: Input file path without filename<br><tt>&lt;#></tt>: Next free number (where file does not exist)<br><tt>*</tt> Page number (for bursting pages)"), cellConstraints.xyw(1, 12, 3));
        this.setOptionsEnabled(false, false, false, false, true);
    }

    private void findSharedLibrary() {
        try {
            PdfToImage.setJavaLibraryPath();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            JOptionPane.showMessageDialog(this.mainForm, noSuchFieldException.getMessage(), "Error reading file", 0);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            JOptionPane.showMessageDialog(this.mainForm, illegalAccessException.getMessage(), "Error reading file", 0);
        }
        String string = PdfToImage.checkForLibraries();
        if (string != null) {
            if (string.equals("nojmupdf")) {
                this.warning.setIcon(new ImageIcon(this.getClass().getResource("/warning.png")));
                this.warning.setToolTipText("<html>This feature is not available<br>in compact version. If you are not<br>using compact version verify that<br>lib/JmuPdf.jar is present and your<br>download was not corrupted.");
                this.multipageTiff.setSelected(false);
                this.fileType.setSelectedItem((Object)PdfToImage.ImageType.PDF);
                this.fileType.setSelectedIndex(0);
            } else if (string.contains(".")) {
                this.warning.setIcon(new ImageIcon(this.getClass().getResource("/warning.png")));
                this.warning.setToolTipText("<html>\"" + string + "\" needs to be in <br>\"" + PdfToImage.getJarFolder() + "\"<br>" + "to export in image file type");
                this.multipageTiff.setSelected(false);
                this.fileType.setSelectedItem((Object)PdfToImage.ImageType.PDF);
                this.fileType.setSelectedIndex(0);
            }
        } else {
            this.warning.setIcon(new ImageIcon(this.getClass().getResource("/info.png")));
            this.warning.setToolTipText("<html>Images will be exported in 72 dpi");
        }
    }

    private String setCorrectExtension(String string) {
        if (!string.equals("") && (this.burst.isSelected() || this.multipageTiff.isSelected())) {
            if (string.contains(".")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            if (this.fileType.getSelectedIndex() == 7 || this.multipageTiff.isSelected()) {
                string = string + ".tiff";
                return string;
            }
            string = string + "." + this.fileType.getSelectedItem().toString().toLowerCase();
            return string;
        }
        if (!(string.equals("") || this.burst.isSelected() || this.multipageTiff.isSelected())) {
            if (string.contains(".")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            return string + ".pdf";
        }
        return "";
    }

    private void whichToEnable(int n) {
        if (n >= 1 && n <= 5) {
            DefaultComboBoxModel<PdfToImage.ColorMode> defaultComboBoxModel = new DefaultComboBoxModel<PdfToImage.ColorMode>(new PdfToImage.ColorMode[]{PdfToImage.ColorMode.RGB, PdfToImage.ColorMode.GRAY});
            if (this.colorMode.getModel().getSize() != 2) {
                this.colorMode.setModel(defaultComboBoxModel);
            }
        } else if (n > 5) {
            DefaultComboBoxModel<PdfToImage.ColorMode> defaultComboBoxModel = new DefaultComboBoxModel<PdfToImage.ColorMode>(new PdfToImage.ColorMode[]{PdfToImage.ColorMode.RGB, PdfToImage.ColorMode.GRAY, PdfToImage.ColorMode.BNW, PdfToImage.ColorMode.BNWI});
            if (this.colorMode.getModel().getSize() != 4) {
                this.colorMode.setModel(defaultComboBoxModel);
            }
        }
        switch (n) {
            case 0: {
                this.setOptionsEnabled(false, false, false, false, true);
                break;
            }
            case 1: {
                this.setOptionsEnabled(true, false, true, false, false);
                break;
            }
            case 2: {
                this.setOptionsEnabled(true, false, false, true, false);
                break;
            }
            case 3: {
                this.setOptionsEnabled(true, false, false, true, false);
                break;
            }
            case 4: {
                this.setOptionsEnabled(true, false, false, true, false);
                break;
            }
            case 5: {
                this.setOptionsEnabled(true, false, false, false, false);
                break;
            }
            case 6: {
                this.setOptionsEnabled(true, false, false, false, false);
                break;
            }
            case 7: {
                this.setOptionsEnabled(true, true, false, true, false);
                break;
            }
            case 100: {
                this.setOptionsEnabled(true, true, false, true, false);
                break;
            }
            default: {
                this.setOptionsEnabled(false, false, false, false, true);
            }
        }
    }

    private void setOptionsEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.colorLabel.setEnabled(bl);
        this.colorMode.setEnabled(bl);
        this.compressionLabel.setEnabled(bl2);
        this.compressionType.setEnabled(bl2);
        this.qualityLabel.setEnabled(bl3);
        this.qualitySlider.setEnabled(bl3);
        this.transparent.setEnabled(bl4);
        this.uncompressed.setEnabled(bl5);
        this.pageMarks.setEnabled(bl5);
        this.optimizeSize.setEnabled(bl5);
        this.fullyCompressed.setEnabled(bl5);
    }

    private boolean matchTransparency(boolean bl) {
        if (this.transparent.isEnabled()) {
            return bl;
        }
        return false;
    }

    public String getTabName() {
        return "Output";
    }

    public void checkRun() throws IOException {
        if (this.outputFile.getText().length() == 0) {
            throw new IOException("No output file selected");
        }
        String string = this.outputFile.getText();
        if (!(this.mainForm.getInputTab().getBatchLength() <= 1 || string.contains("<F>") || string.contains("<FX>") || string.contains("<P>") || string.contains("<#>"))) {
            throw new IOException("Variables in output file name required for batch mode");
        }
        this.mainForm.getInputTab().setUseTempFiles(this.tempfiles.isSelected());
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        if (this.pageMarks.isSelected()) {
            if (this.uncompressed.isSelected()) {
                pdfTweak.addPageMarks();
            } else {
                pdfTweak.removePageMarks();
            }
        }
        boolean bl = this.matchTransparency(this.transparent.isSelected());
        boolean bl2 = this.fileType.getSelectedIndex() != 0 && !this.multipageTiff.isSelected();
        PdfToImage.ImageType imageType = (PdfToImage.ImageType)((Object)this.fileType.getSelectedItem());
        if (this.multipageTiff.isSelected()) {
            imageType = PdfToImage.ImageType.TIFF;
        }
        pdfTweak.setPdfImages(new PdfToImage(bl2, (PdfToImage.ColorMode)((Object)this.colorMode.getSelectedItem()), imageType, (PdfToImage.TiffCompression)((Object)this.compressionType.getSelectedItem()), this.qualitySlider.getValue(), bl));
        pdfTweak.writeOutput(this.outputFile.getText(), this.multipageTiff.isSelected(), this.burst.isSelected(), this.uncompressed.isSelected(), this.optimizeSize.isSelected(), this.fullyCompressed.isSelected());
        return null;
    }
}

