/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jpdftweak.core.PageDimension;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.tabs.Tab;

public class PageSizeTab
extends Tab {
    private JTextField scaleWidth;
    private JTextField scaleHeight;
    private JCheckBox rotatePages;
    private JCheckBox fixRotation;
    private JCheckBox cropPages;
    private JCheckBox scalePages;
    private JCheckBox scaleNoPreserve;
    private JCheckBox scaleCenter;
    private JCheckBox preserveHyperlinks;
    private JComboBox rotatePortrait;
    private JComboBox rotateLandscape;
    private JComboBox scaleSize;
    private JComboBox cropTo;

    public PageSizeTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p, f:p:g, f:p", "f:p, 10dlu,f:p, f:p, f:p, 10dlu, f:p, 10dlu, f:p,f:p, f:p,f:p, f:p,f:p, 10dlu, f:p, f:p:g"));
        CellConstraints cellConstraints = new CellConstraints();
        this.cropPages = new JCheckBox("Crop to:");
        this.add((Component)this.cropPages, cellConstraints.xy(1, 1));
        this.cropTo = new JComboBox<PdfTweak.PageBox>(new PdfTweak.PageBox[]{PdfTweak.PageBox.MediaBox, PdfTweak.PageBox.CropBox, PdfTweak.PageBox.BleedBox, PdfTweak.PageBox.TrimBox, PdfTweak.PageBox.ArtBox});
        this.add(this.cropTo, cellConstraints.xyw(2, 1, 2));
        this.cropPages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageSizeTab.this.cropTo.setEnabled(PageSizeTab.this.cropPages.isSelected());
            }
        });
        this.cropTo.setSelectedItem((Object)PdfTweak.PageBox.CropBox);
        this.cropTo.setEnabled(false);
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 2, 3));
        this.rotatePages = new JCheckBox("Rotate pages");
        this.add((Component)this.rotatePages, cellConstraints.xyw(1, 3, 3));
        this.add((Component)new JLabel("Portrait pages:"), cellConstraints.xy(1, 4));
        this.rotatePortrait = new JComboBox<String>(new String[]{"Keep", "Right", "Upside-Down", "Left"});
        this.add(this.rotatePortrait, cellConstraints.xyw(2, 4, 2));
        this.add((Component)new JLabel("Landscape pages:"), cellConstraints.xy(1, 5));
        this.rotateLandscape = new JComboBox<String>(new String[]{"Keep", "Right", "Upside-Down", "Left"});
        this.add(this.rotateLandscape, cellConstraints.xyw(2, 5, 2));
        this.rotatePages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageSizeTab.this.rotatePortrait.setEnabled(PageSizeTab.this.rotatePages.isSelected());
                PageSizeTab.this.rotateLandscape.setEnabled(PageSizeTab.this.rotatePages.isSelected());
                if (!PageSizeTab.this.rotatePages.isSelected()) {
                    PageSizeTab.this.rotatePortrait.setSelectedIndex(0);
                    PageSizeTab.this.rotateLandscape.setSelectedIndex(0);
                }
            }
        });
        this.rotatePortrait.setEnabled(false);
        this.rotateLandscape.setEnabled(false);
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 6, 3));
        this.fixRotation = new JCheckBox("Remove implicit page rotation");
        this.add((Component)this.fixRotation, cellConstraints.xyw(1, 7, 3));
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 8, 3));
        this.scalePages = new JCheckBox("Scale pages");
        this.add((Component)this.scalePages, cellConstraints.xyw(1, 9, 3));
        this.add((Component)new JLabel("Page Size:"), cellConstraints.xy(1, 10));
        this.scaleSize = new JComboBox();
        this.add(this.scaleSize, cellConstraints.xyw(2, 10, 2));
        this.add((Component)new JLabel("Page Width:"), cellConstraints.xy(1, 11));
        this.scaleWidth = new JTextField();
        this.add((Component)this.scaleWidth, cellConstraints.xy(2, 11));
        this.add((Component)new JLabel("PostScript points"), cellConstraints.xy(3, 11));
        this.add((Component)new JLabel("Page Height:"), cellConstraints.xy(1, 12));
        this.scaleHeight = new JTextField();
        this.add((Component)this.scaleHeight, cellConstraints.xy(2, 12));
        this.add((Component)new JLabel("PostScript points"), cellConstraints.xy(3, 12));
        this.scaleCenter = new JCheckBox("Center instead of enlarging");
        this.add((Component)this.scaleCenter, cellConstraints.xyw(1, 13, 3));
        this.scaleNoPreserve = new JCheckBox("Do not preserve aspect ratio");
        this.add((Component)this.scaleNoPreserve, cellConstraints.xyw(1, 13, 3));
        this.scalePages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageSizeTab.this.scaleSize.setEnabled(PageSizeTab.this.scalePages.isSelected());
                PageSizeTab.this.scaleWidth.setEnabled(PageSizeTab.this.scalePages.isSelected());
                PageSizeTab.this.scaleHeight.setEnabled(PageSizeTab.this.scalePages.isSelected());
                PageSizeTab.this.scaleCenter.setEnabled(PageSizeTab.this.scalePages.isSelected());
                PageSizeTab.this.scaleNoPreserve.setEnabled(PageSizeTab.this.scalePages.isSelected());
            }
        });
        this.scaleSize.setEnabled(false);
        for (PageDimension pageDimension : PageDimension.getCommonSizes()) {
            this.scaleSize.addItem(pageDimension);
        }
        this.scaleSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PageSizeTab.this.updateScaleSize();
            }
        });
        this.scaleSize.setSelectedIndex(0);
        this.updateScaleSize();
        this.scaleWidth.setEnabled(false);
        this.scaleHeight.setEnabled(false);
        this.scaleCenter.setEnabled(false);
        this.scaleNoPreserve.setEnabled(false);
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 15, 3));
        this.preserveHyperlinks = new JCheckBox("Preserve hyperlinks (EXPERIMENTAL)");
        this.add((Component)this.preserveHyperlinks, cellConstraints.xyw(1, 16, 3));
    }

    protected void updateScaleSize() {
        this.scaleWidth.setText("" + ((PageDimension)this.scaleSize.getSelectedItem()).getWidth());
        this.scaleHeight.setText("" + ((PageDimension)this.scaleSize.getSelectedItem()).getHeight());
    }

    public String getTabName() {
        return "Page Size";
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        if (this.preserveHyperlinks.isSelected()) {
            pdfTweak.preserveHyperlinks();
        }
        if (this.cropPages.isSelected()) {
            pdfTweak.cropPages((PdfTweak.PageBox)((Object)this.cropTo.getSelectedItem()));
        }
        if (this.rotatePages.isSelected()) {
            pdfTweak.rotatePages(this.rotatePortrait.getSelectedIndex(), this.rotateLandscape.getSelectedIndex());
        }
        if (this.fixRotation.isSelected()) {
            pdfTweak.removeRotation();
        }
        if (this.scalePages.isSelected()) {
            float f;
            float f2;
            try {
                f2 = Float.parseFloat(this.scaleWidth.getText());
                f = Float.parseFloat(this.scaleHeight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid scale size");
            }
            pdfTweak.scalePages(f2, f, this.scaleCenter.isSelected(), !this.scaleNoPreserve.isSelected());
        }
        return pdfTweak;
    }
}

