/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import jpdftweak.core.PageDimension;
import jpdftweak.core.PdfTweak;
import jpdftweak.core.ShuffleRule;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.PreviewPanel;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.Tab;

public class ShuffleTab
extends Tab {
    private PreviewPanel pp;
    private JCheckBox shufflePages;
    private JCheckBox blockShuffle;
    private JButton updatePreview;
    private JButton use;
    private JComboBox previewFormat;
    private JComboBox preset;
    private JTextField pagesPerPass;
    private JTextField configString;
    private JTextField blockSize;
    private TableComponent shuffleRulesTable;
    private int shufflePagesPerPass;
    private ShuffleRule[] shuffleRules;
    private final MainForm mf;

    public ShuffleTab(MainForm mainForm) {
        super(new BorderLayout());
        this.mf = mainForm;
        JPanel jPanel = new JPanel((LayoutManager)new FormLayout("f:p, f:p:g, f:p, f:p", "f:p, f:p, f:p, 10dlu, f:p, f:p, f:p:g"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        this.add((Component)jSplitPane, "Center");
        jSplitPane.setResizeWeight(0.5);
        CellConstraints cellConstraints = new CellConstraints();
        this.previewFormat = new JComboBox();
        jPanel2.add(this.previewFormat, "North");
        this.pp = new PreviewPanel();
        jPanel2.add((Component)this.pp, "Center");
        for (PageDimension pageDimension : PageDimension.getCommonSizes()) {
            this.previewFormat.addItem(pageDimension);
        }
        this.previewFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShuffleTab.this.pp.setPageFormat((PageDimension)ShuffleTab.this.previewFormat.getSelectedItem());
            }
        });
        this.previewFormat.setSelectedIndex(0);
        this.pp.setPreferredSize(new Dimension(50, 100));
        this.previewFormat.setMinimumSize(new Dimension(50, this.previewFormat.getMinimumSize().height));
        this.shufflePages = new JCheckBox("Shuffle pages");
        jPanel.add((Component)this.shufflePages, cellConstraints.xyw(1, 1, 4));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShuffleTab.this.updateEnabledState();
            }
        };
        this.shufflePages.addActionListener(actionListener);
        jPanel.add((Component)new JLabel("Preset: "), cellConstraints.xy(1, 2));
        this.preset = new JComboBox();
        jPanel.add(this.preset, cellConstraints.xyw(2, 2, 3));
        jPanel.add((Component)new JLabel("Config string: "), cellConstraints.xy(1, 3));
        this.configString = new JTextField();
        jPanel.add((Component)this.configString, cellConstraints.xyw(2, 3, 2));
        for (String string : ShuffleRule.predefinedRuleSets) {
            this.preset.addItem(string.substring(string.indexOf(61) + 1));
        }
        this.preset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (String string : ShuffleRule.predefinedRuleSets) {
                    if (!string.endsWith("=" + (String)ShuffleTab.this.preset.getSelectedItem())) continue;
                    ShuffleTab.this.configString.setText(string.substring(0, string.indexOf(61)));
                    ShuffleTab.this.parseConfigString();
                }
            }
        });
        this.use = new JButton("Use");
        jPanel.add((Component)this.use, cellConstraints.xy(4, 3));
        this.use.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShuffleTab.this.parseConfigString();
            }
        });
        jPanel.add((Component)new JSeparator(), cellConstraints.xyw(1, 4, 4));
        jPanel.add((Component)new JLabel("Each pass covers  "), cellConstraints.xy(1, 5));
        this.pagesPerPass = new JTextField("1");
        jPanel.add((Component)this.pagesPerPass, cellConstraints.xy(2, 5));
        jPanel.add((Component)new JLabel("  page(s) "), cellConstraints.xy(3, 5));
        this.updatePreview = new JButton("Update");
        jPanel.add((Component)this.updatePreview, cellConstraints.xy(4, 5));
        this.updatePreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShuffleTab.this.parseGUI();
            }
        });
        this.blockShuffle = new JCheckBox("Shuffle blocks of  ");
        jPanel.add((Component)this.blockShuffle, cellConstraints.xy(1, 6));
        this.blockSize = new JTextField("20");
        jPanel.add((Component)this.blockSize, cellConstraints.xy(2, 6));
        jPanel.add((Component)new JLabel(" pages individually"), cellConstraints.xyw(3, 6, 2));
        this.blockShuffle.addActionListener(actionListener);
        this.shuffleRulesTable = new TableComponent(new String[]{"Page", "OffsetX", "OffsetY", "ScaleFactor", "Rotate", "NewPageBefore", "FrameWidth"}, new Class[]{String.class, String.class, String.class, Double.class, String.class, Boolean.class, Double.class}, new Object[]{"+1", "0%", "0%", 1.0, "None", true, 0.0});
        jPanel.add((Component)this.shuffleRulesTable, cellConstraints.xyw(1, 7, 4));
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"None", "Left", "Upside-Down", "Right"});
        this.shuffleRulesTable.getTable().getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(jComboBox));
        this.shuffleRulesTable.getScrollPane().setPreferredSize(new Dimension(400, 100));
        this.preset.setSelectedIndex(0);
        this.updateEnabledState();
    }

    protected void parseGUI() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = Integer.parseInt(this.pagesPerPass.getText());
            stringBuffer.append(n);
            if (this.blockShuffle.isSelected()) {
                stringBuffer.append(',').append(Integer.parseInt(this.blockSize.getText()));
            }
            stringBuffer.append(':');
            for (int i = 0; i < this.shuffleRulesTable.getRowCount(); ++i) {
                Object[] objectArray = this.shuffleRulesTable.getRow(i);
                String string = (String)objectArray[0];
                ShuffleRule.PageBase pageBase = ShuffleRule.PageBase.ABSOLUTE;
                if (string.startsWith("+")) {
                    pageBase = ShuffleRule.PageBase.BEGINNING;
                    string = string.substring(1);
                } else if (string.startsWith("-")) {
                    pageBase = ShuffleRule.PageBase.END;
                    string = string.substring(1);
                }
                int n2 = Integer.parseInt(string);
                if (n2 <= 0) {
                    throw new NumberFormatException((String)objectArray[0]);
                }
                string = (String)objectArray[1];
                boolean bl = false;
                boolean bl2 = false;
                if (string.endsWith("%")) {
                    bl = true;
                    string = string.substring(0, string.length() - 1);
                }
                double d = Double.parseDouble(string);
                string = (String)objectArray[2];
                if (string.endsWith("%")) {
                    bl2 = true;
                    string = string.substring(0, string.length() - 1);
                }
                double d2 = Double.parseDouble(string);
                double d3 = (Double)objectArray[3];
                char c = ((String)objectArray[4]).charAt(0);
                boolean bl3 = (Boolean)objectArray[5];
                double d4 = (Double)objectArray[6];
                ShuffleRule shuffleRule = new ShuffleRule(bl3, pageBase, n2, c, d3, d, bl, d2, bl2, d4);
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(shuffleRule.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.mf, "Unparsable option: " + numberFormatException.getMessage());
            return;
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this.mf, "Please fill in all the fields.");
            return;
        }
        this.configString.setText(stringBuffer.toString());
        this.parseConfigString();
    }

    private void parseConfigString() {
        try {
            this.parseConfigStringInternal();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            JOptionPane.showMessageDialog(this.mf, "Unparsable config string: " + numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            JOptionPane.showMessageDialog(this.mf, "Unparsable config string: " + this.configString.getText());
        }
    }

    private void parseConfigStringInternal() {
        String string = this.configString.getText();
        int[] nArray = new int[2];
        ShuffleRule[] shuffleRuleArray = ShuffleRule.parseRuleSet(string, nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        this.pp.setConfig(shuffleRuleArray);
        this.pagesPerPass.setText("" + n);
        if (n2 == 0) {
            this.blockShuffle.setSelected(false);
        } else {
            this.blockShuffle.setSelected(true);
            this.blockSize.setText("" + n2);
        }
        this.shuffleRulesTable.clear();
        for (int i = 0; i < shuffleRuleArray.length; ++i) {
            this.shuffleRulesTable.addRow(shuffleRuleArray[i].getPageString(), shuffleRuleArray[i].getOffsetXString(), shuffleRuleArray[i].getOffsetYString(), shuffleRuleArray[i].getScale(), this.rotateName(shuffleRuleArray[i].getRotate()), shuffleRuleArray[i].isNewPageBefore(), shuffleRuleArray[i].getFrameWidth());
        }
        this.shufflePagesPerPass = n;
        this.shuffleRules = shuffleRuleArray;
        this.updateEnabledState();
    }

    private String rotateName(char c) {
        switch (c) {
            case 'N': {
                return "None";
            }
            case 'L': {
                return "Left";
            }
            case 'R': {
                return "Right";
            }
            case 'U': {
                return "Upside-Down";
            }
        }
        throw new IllegalArgumentException();
    }

    private void updateEnabledState() {
        boolean bl = this.shufflePages.isSelected();
        this.updatePreview.setEnabled(bl);
        this.use.setEnabled(bl);
        this.previewFormat.setEnabled(bl);
        this.preset.setEnabled(bl);
        this.pagesPerPass.setEnabled(bl);
        this.blockShuffle.setEnabled(bl);
        this.blockSize.setEnabled(bl && this.blockShuffle.isSelected());
        this.configString.setEnabled(bl);
        this.shuffleRulesTable.setEnabled(bl);
    }

    public String getTabName() {
        return "Shuffle/N-up";
    }

    public void checkRun() throws IOException {
        this.shuffleRulesTable.checkRun("shuffle rule");
        if (this.blockShuffle.isSelected()) {
            try {
                int n = Integer.parseInt(this.blockSize.getText());
                if (n < 2) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid shuffle block size");
            }
        }
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        if (this.shufflePages.isSelected()) {
            int n = this.blockShuffle.isSelected() ? Integer.parseInt(this.blockSize.getText()) : 0;
            pdfTweak.shufflePages(this.shufflePagesPerPass, n, this.shuffleRules);
        }
        return pdfTweak;
    }
}

