/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

class FlagCanvas
extends Canvas {
    private boolean selected = false;
    Container pappy;
    Image image;
    boolean trueSizeKnown = false;
    Dimension minSize;
    int w;
    int h;

    public FlagCanvas(Image image, IntlWindow intlWindow, int n, int n2) {
        if (image == null) {
            System.err.println("Canvas got invalid image object!");
            return;
        }
        this.image = image;
        this.pappy = intlWindow;
        this.w = n + 2;
        this.h = n2 + 2;
        this.minSize = new Dimension(this.w, this.h);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        ((IntlWindow)this.pappy).selectFlag(this);
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public synchronized Dimension minimumSize() {
        return this.minSize;
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            if (!this.trueSizeKnown) {
                int n = this.image.getWidth(this);
                int n2 = this.image.getHeight(this);
                if (n > 0 && n2 > 0) {
                    this.trueSizeKnown = true;
                    this.w = n + 2;
                    this.h = n2 + 2;
                    this.minSize = new Dimension(this.w, this.h);
                    this.resize(this.w, this.h);
                    this.pappy.validate();
                }
            }
            graphics.drawImage(this.image, 1, 1, this);
            if (this.selected) {
                graphics.draw3DRect(0, 0, this.w - 1, this.h - 1, true);
            }
        }
    }
}

