/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

class ImageCanvas extends Canvas {
    Container pappy;
    Image image;
    boolean trueSizeKnown = false;
    Dimension minSize;
    int w, h;

    public ImageCanvas(Image image, Container parent, 
		              int initialWidth, int initialHeight) {
	if (image == null) {
	    System.err.println("Canvas got invalid image object!");
	    return;
	}

	this.image = image;
        pappy = parent;

	w = initialWidth;
	h = initialHeight;

	minSize = new Dimension(w,h);
    }

    public Dimension preferredSize() {
 	return minimumSize();
    }

    public synchronized Dimension minimumSize() {
	return minSize;
    }

    public void paint (Graphics g) {
	if (image != null) {
	    if (!trueSizeKnown) {
	        int imageWidth = image.getWidth(this);
	        int imageHeight = image.getHeight(this);

	        if ((imageWidth > 0) && (imageHeight > 0)) {
		    trueSizeKnown = true;

		    //Component-initiated resizing.
		    w = imageWidth;
		    h = imageHeight;
		    minSize = new Dimension(w,h);
		    resize(w, h);
		    pappy.validate();
	        }
	    }

	    g.drawImage(image, 0, 0, this);
	    g.drawRect(0, 0, w - 1, h - 1);
	}
    }

}


public class ImageApplet extends Applet {
    public void init() { 
        Image image1 = getImage(getCodeBase(), "../images/kwalrath.gif");
        Image image2 = getImage(getCodeBase(), "../images/innocence.small.gif");

        ImageCanvas ic1 = new ImageCanvas(image1, this, 50, 50);
        ImageCanvas ic2 = new ImageCanvas(image2, this, 100, 100);

        add(ic1);
        add(ic2);
    
	validate();
    }

}
