/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

public class ListDemo extends Applet {
    TextArea output;
    List spanish, italian; 

    public void init() {

        //Build first list, which allows multiple selections.
        spanish = new List(4, true); //prefer 4 items visible
        spanish.addItem("uno");
        spanish.addItem("dos");
        spanish.addItem("tres");
        spanish.addItem("cuatro");
        spanish.addItem("cinco");
        spanish.addItem("seis");
        spanish.addItem("siete");

        //Build second list, which allows one selection at a time.
        italian = new List(); //Defaults to none visible, only one selectable
        italian.addItem("uno");
        italian.addItem("due");
        italian.addItem("tre");
        italian.addItem("quattro");
        italian.addItem("cinque");
        italian.addItem("sei");
        italian.addItem("sette");

        //Add lists to the Applet. 
        GridBagLayout gridBag = new GridBagLayout();
        setLayout(gridBag);

        //Can't put text area on right due to GBL bug
        //(can't span rows in any column but the first). 
        output = new TextArea(10, 40);
        output.setEditable(false);
        GridBagConstraints tc = new GridBagConstraints();
        tc.fill = GridBagConstraints.BOTH;
        tc.weightx = 1.0;
        tc.weighty = 1.0;
        tc.gridheight = 2;
        gridBag.setConstraints(output, tc);
        add(output);

        GridBagConstraints lc = new GridBagConstraints();
        lc.fill = GridBagConstraints.VERTICAL;
        lc.gridwidth = GridBagConstraints.REMAINDER; //end row
        gridBag.setConstraints(spanish, lc);
        add(spanish);
        gridBag.setConstraints(italian, lc);
        add(italian);

        validate();
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof List) {
            String language = (e.target == spanish) ?
                              "Spanish" : "Italian";
            output.appendText("Action event occurred on \""
                              + (String)arg  + "\" in "
                              + language + ".\n");
	}
	return true;
    }

    public boolean handleEvent(Event e) {
        if (e.target instanceof List) {
            List list = (List)(e.target);
            String language = (list == spanish) ?
                              "Spanish" : "Italian";

            switch (e.id) {
              case Event.LIST_SELECT:
                int sIndex = ((Integer)e.arg).intValue();
                output.appendText("Select event occurred on item #"
                                  + sIndex + " (\""
                                  + list.getItem(sIndex)  + "\") in "
                              + language + ".\n");
                break;
              case Event.LIST_DESELECT:
                int dIndex = ((Integer)e.arg).intValue();
                output.appendText("Deselect event occurred on item #"
                                  + dIndex + " (\""
                                  + list.getItem(dIndex)  + "\") in "
                              + language + ".\n");
            }
        }
        return super.handleEvent(e);
    }
}
