/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class MetalScrollPaneUI
extends BasicScrollPaneUI {
    private PropertyChangeListener scrollBarSwapListener;

    protected PropertyChangeListener createScrollBarSwapListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("verticalScrollBar") || string.equals("horizontalScrollBar")) {
                    ((JScrollBar)propertyChangeEvent.getOldValue()).putClientProperty("JScrollBar.isFreeStanding", null);
                    ((JScrollBar)propertyChangeEvent.getNewValue()).putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollPaneUI();
    }

    public void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.scrollBarSwapListener = this.createScrollBarSwapListener();
        jScrollPane.addPropertyChangeListener(this.scrollBarSwapListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        jScrollBar.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        jScrollBar2.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
    }

    public void uninstallListeners(JScrollPane jScrollPane) {
        super.uninstallListeners(jScrollPane);
        jScrollPane.removePropertyChangeListener(this.scrollBarSwapListener);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        jScrollBar.putClientProperty("JScrollBar.isFreeStanding", null);
        jScrollBar2.putClientProperty("JScrollBar.isFreeStanding", null);
    }
}

