/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int GoodBreakWeight = 1000;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    static final Position.Bias[] sharedBiasReturn = new Position.Bias[1];
    private View parent;
    private Element elem;

    public View(Element element) {
        this.elem = element;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public View createFragment(int n, int n2) {
        return this;
    }

    public float getAlignment(int n) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.elem.getAttributes();
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (f2 > this.getPreferredSpan(n)) {
            return 1000;
        }
        return 0;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return null;
    }

    public Container getContainer() {
        View view = this.getParent();
        return view != null ? view.getContainer() : null;
    }

    public Document getDocument() {
        return this.elem.getDocument();
    }

    public Element getElement() {
        return this.elem;
    }

    public int getEndOffset() {
        return this.elem.getEndOffset();
    }

    public float getMaximumSpan(int n) {
        int n2 = this.getResizeWeight(n);
        if (n2 == 0) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int n) {
        int n2 = this.getResizeWeight(n);
        if (n2 == 0) {
            return this.getPreferredSpan(n);
        }
        return 0.0f;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        biasArray[0] = Position.Bias.Forward;
        switch (n2) {
            case 1: {
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Rectangle rectangle = jTextComponent.modelToView(n);
                n = Utilities.getPositionAbove(jTextComponent, n, rectangle.x);
                break;
            }
            case 5: {
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Rectangle rectangle = jTextComponent.modelToView(n);
                n = Utilities.getPositionBelow(jTextComponent, n, rectangle.x);
                break;
            }
            case 7: {
                if (n == -1) {
                    n = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                n = Math.max(0, n - 1);
                break;
            }
            case 3: {
                if (n == -1) {
                    n = this.getStartOffset();
                    break;
                }
                n = Math.min(n + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }

    public View getParent() {
        return this.parent;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int n) {
        return 0;
    }

    public int getStartOffset() {
        return this.elem.getStartOffset();
    }

    public View getView(int n) {
        return null;
    }

    public int getViewCount() {
        return 0;
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        return view != null ? view.getViewFactory() : null;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public boolean isVisible() {
        return true;
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, Position.Bias.Forward);
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        return rectangle2;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        View view2 = this.getParent();
        if (view2 != null) {
            view2.preferenceChanged(this, bl, bl2);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void setParent(View view) {
        this.parent = view;
    }

    public void setSize(float f, float f2) {
    }

    public int viewToModel(float f, float f2, Shape shape) {
        View.sharedBiasReturn[0] = Position.Bias.Forward;
        return this.viewToModel(f, f2, shape, sharedBiasReturn);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);
}

