/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    protected FontMetrics metrics;
    Element longLine;
    Font font;
    Segment lineBuffer = new Segment();
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public PlainView(Element element) {
        super(element);
    }

    Shape adjustPaintRegion(Shape shape) {
        return shape;
    }

    private void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        Document document = this.getDocument();
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            Element element2 = element.getElement(n3);
            int n4 = this.getLineWidth(element2);
            if (n4 > n2) {
                n2 = n4;
                this.longLine = element2;
            }
            ++n3;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    private void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n);
            Rectangle rectangle2 = this.lineToRect(shape, n2);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    private int drawElement(Element element, Graphics graphics, int n, int n2) throws BadLocationException {
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        n4 = Math.min(this.getDocument().getLength(), n4);
        AttributeSet attributeSet = element.getAttributes();
        if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
            graphics.setColor(this.unselected);
            n = Utilities.drawComposedText(attributeSet, graphics, n, n2, n3 - element.getStartOffset(), n4 - element.getStartOffset());
        } else if (this.sel0 == this.sel1) {
            n = this.drawUnselectedText(graphics, n, n2, n3, n4);
        } else if (n3 >= this.sel0 && n3 <= this.sel1 && n4 >= this.sel0 && n4 <= this.sel1) {
            n = this.drawSelectedText(graphics, n, n2, n3, n4);
        } else if (this.sel0 >= n3 && this.sel0 <= n4) {
            if (this.sel1 >= n3 && this.sel1 <= n4) {
                n = this.drawUnselectedText(graphics, n, n2, n3, this.sel0);
                n = this.drawSelectedText(graphics, n, n2, this.sel0, this.sel1);
                n = this.drawUnselectedText(graphics, n, n2, this.sel1, n4);
            } else {
                n = this.drawUnselectedText(graphics, n, n2, n3, this.sel0);
                n = this.drawSelectedText(graphics, n, n2, this.sel0, n4);
            }
        } else if (this.sel1 >= n3 && this.sel1 <= n4) {
            n = this.drawSelectedText(graphics, n, n2, n3, this.sel1);
            n = this.drawUnselectedText(graphics, n, n2, this.sel1, n4);
        } else {
            n = this.drawUnselectedText(graphics, n, n2, n3, n4);
        }
        return n;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        Element element = this.getElement().getElement(n);
        try {
            if (element.isLeaf()) {
                this.drawElement(element, graphics, n2, n3);
            } else {
                int n4 = element.getElementCount();
                int n5 = 0;
                while (n5 < n4) {
                    Element element2 = element.getElement(n5);
                    n2 = this.drawElement(element2, graphics, n2, n3);
                    ++n5;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render line: " + n);
        }
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        document.getText(n3, n4 - n3, this.lineBuffer);
        return Utilities.drawTabbedText(this.lineBuffer, n, n2, graphics, this, n3);
    }

    protected final Segment getLineBuffer() {
        return this.lineBuffer;
    }

    private int getLineWidth(Element element) {
        int n;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        try {
            element.getDocument().getText(n2, n3 - n2, this.lineBuffer);
            n = Utilities.getTabbedTextWidth(this.lineBuffer, this.metrics, this.tabBase, this, n2);
        }
        catch (BadLocationException badLocationException) {
            n = 0;
        }
        return n;
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    private Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        document.getText(n3, n - n3, this.lineBuffer);
        int n4 = Utilities.getTabbedTextWidth(this.lineBuffer, this.metrics, this.tabBase, this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        Shape shape2 = shape;
        shape = this.adjustPaintRegion(shape);
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        graphics.setFont(jTextComponent.getFont());
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = this.metrics.getHeight();
        int n2 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n3 = Math.max(0, n2 / n);
        int n4 = rectangle2.y - rectangle.y;
        int n5 = Math.max(0, n4 / n);
        int n6 = rectangle.height / n;
        if (rectangle.height % n != 0) {
            ++n6;
        }
        Rectangle rectangle3 = this.lineToRect(shape, n5);
        int n7 = rectangle3.y + this.metrics.getAscent();
        int n8 = rectangle3.x;
        Element element = this.getElement();
        int n9 = element.getElementCount();
        int n10 = Math.min(n9, n6 - n3);
        --n9;
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        int n11 = n5;
        while (n11 < n10) {
            if (layeredHighlighter != null) {
                Element element2 = element.getElement(n11);
                if (n11 == n9) {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset(), shape2, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset() - 1, shape2, jTextComponent, this);
                }
            }
            this.drawLine(n11, graphics, n8, n7);
            n7 += n;
            ++n11;
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        this.getDocument().putProperty("lineLimit", null);
        super.preferenceChanged(view, bl, bl2);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container = this.getContainer();
        if (container.isShowing()) {
            Element[] elementArray;
            this.updateMetrics();
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
            Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
            if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
                int n;
                if (elementArray2 != null) {
                    n = this.getLineWidth(this.longLine);
                    int n2 = 0;
                    while (n2 < elementArray2.length) {
                        int n3 = this.getLineWidth(elementArray2[n2]);
                        if (n3 > n) {
                            n = n3;
                            this.longLine = elementArray2[n2];
                        }
                        ++n2;
                    }
                }
                if (elementArray != null) {
                    n = 0;
                    while (n < elementArray.length) {
                        if (elementArray[n] == this.longLine) {
                            this.calculateLongestLine();
                            break;
                        }
                        ++n;
                    }
                }
                this.preferenceChanged(null, true, true);
                container.repaint();
            } else {
                Element element2 = this.getElement();
                int n = element2.getElementIndex(documentEvent.getOffset());
                this.damageLineRange(n, n, shape, container);
                if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                    int n4 = this.getLineWidth(this.longLine);
                    Element element3 = element2.getElement(n);
                    if (element3 == this.longLine) {
                        this.preferenceChanged(null, true, false);
                    } else if (this.getLineWidth(element3) > n4) {
                        this.longLine = element3;
                        this.preferenceChanged(null, true, false);
                    }
                } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n) == this.longLine) {
                    this.calculateLongestLine();
                    this.preferenceChanged(null, true, false);
                }
            }
        }
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.metrics.getHeight());
        if (n3 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            document.getText(n4, n5 - n4, this.lineBuffer);
            this.tabBase = rectangle.x;
            int n6 = n4 + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, this.tabBase, n, this, n4);
            return n6;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }
}

