
package com.sun.java.swing.plaf.mac;

import javax.swing.filechooser.*;
import java.io.*;

class MacFileSystemView extends FileSystemView {

/**
* Returns true if the given file is a root.
*/
    public boolean isRoot( File f ) {
        if ( f == null || f.getParent() == null ) {
            return false;
        }
        else {
            return f.getParent().equals( "/" );
        }
    }

/**
* creates a new folder with a default folder name.
*/
    public File createNewFolder(File containingDir) throws IOException {
        if ( containingDir == null ) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
// Using default folder name
        newFolder = createFileObject(containingDir, "untitled folder");
        int i = 2;
        while ( newFolder.exists() && (i < 100) ) {
            newFolder = createFileObject(containingDir, "untitled folder (" + i + ")");
            i++;
        }

        if ( newFolder.exists() ) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        else {
            newFolder.mkdirs();
        }

        return newFolder;
    }

/**
* Returns whether a file is hidden or not. On Windows
* there is currently no way to get this information from
* io.File, therefore always return false.
*/
    public boolean isHiddenFile(File f) {
        return false;
    }

/**
* Returns all root partitians on this system. On Windows, this
* will be the A: through Z: drives.
*/
    public File[] getRoots() {
        File realRoot = new File( "/" );
        String[] rootNames = realRoot.list();
        File[] roots = new File[ rootNames.length ];

        for ( int i = 0; i < rootNames.length; ++i ) {
            roots[i] = new File( realRoot.getPath() + rootNames[i] );
        }

        return roots;
    }
}


