/*
 * @(#)MetalIconFactory.java	1.22 98/04/24
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import javax.swing.plaf.UIResource;
import java.awt.*;
import java.io.Serializable;

/**
 * Factory object that can vend Icons appropriate for Metal.
 * These are used extensively in Metal via the defaults mechanism.
 * While other Look and Feels use GIFs for some of these, doing this
 * work in code facilitates things when switching to other Themes.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.22 04/24/98
 * @author Tom Santos
 */
public class MacIconFactory implements Serializable {

    // List of code-drawn Icons
    static Icon sliderHorizontalThumbIcon;
    static Icon sliderVerticalThumbIcon;

    // Accessor functions for Icons. Does the caching work.
    static Icon getSliderHorizontalThumbIcon() {
        if ( sliderHorizontalThumbIcon == null ) {
            sliderHorizontalThumbIcon = new SliderHorizontalThumbIcon();
        }
        return sliderHorizontalThumbIcon;
    }

    static Icon getSliderVerticalThumbIcon() {
        if ( sliderVerticalThumbIcon == null ) {
            sliderVerticalThumbIcon = new SliderVerticalThumbIcon();
        }
        return sliderVerticalThumbIcon;
    }

    static class SliderHorizontalThumbIcon implements Icon, Serializable {
        public void paintIcon( Component c, Graphics g, int x, int y ) {
            JSlider slider = (JSlider)c;
            if ( !(slider.getUI() instanceof MacSliderUI) ) {
                return;
            }
            MacSliderUI ui = (MacSliderUI)slider.getUI();

            g.translate( x, y );

            int right = getIconWidth() - 1;
            int bottom = getIconHeight() - 1;

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccent() :
                            MacLookAndFeel.getAccentHighlight() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray2() );
            }
            g.fillRect( 1, 1, 13, 10 );                  // main background fill
            g.fillRect( 3, 11, 9, 2 );                   // more background fill
            g.drawLine( 6, 13, 8, 13 );                  // more background fill

            g.setColor( ui.thumbPressed ?
                        MacLookAndFeel.getGray2() :
                        MacLookAndFeel.getGray0() );
            g.drawLine( 1, 1, 1, 1 );
            g.drawLine( 4, 3, 4, 3 );
            g.drawLine( 6, 3, 6, 3 );
            g.drawLine( 8, 3, 8, 3 );

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentHighlight() :
                            MacLookAndFeel.getAccentLightHighlight() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray3() );
            }
            g.drawLine( 2, 1, right - 2, 1 );            // top highlight
            g.drawLine( 1, 2, 1, 9 );                    // left highlight
            g.drawLine( 4, 4, 4, 8 );                    // left-center highlight
            g.drawLine( 6, 4, 6, 8 );                    // center-center highlight
            g.drawLine( 8, 4, 8, 8 );                    // right-center highlight

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentShadow() :
                            MacLookAndFeel.getAccent() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray3() );
            }
            g.drawLine( 2, 10, 6, 14 );                  // left slant shadow
            g.drawLine( 7, 14, 7, 14 );                  // fill dot
            g.drawLine( 8, 14, right - 2, 10 );          // right slant shadow
            g.drawLine( right - 1, 2, right - 1, 9 );    // right shadow

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentDarkShadow() :
                            MacLookAndFeel.getAccentShadow() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray5() );
            }
            g.drawLine( 5, 4, 5, 9 );                    // left-center shadow
            g.drawLine( 7, 4, 7, 9 );                    // center-center shadow
            g.drawLine( 9, 4, 9, 9 );                    // right-center shadow

            g.setColor( MacLookAndFeel.getBlack() );
            g.drawLine( 1, 0, right - 1, 0 );            // top
            g.drawLine( 0, 1, 0, 9 );                    // left
            g.drawLine( right, 1, right, 9 );            // right
            g.drawLine( 0, 9, 6, bottom );               // left slant
            g.drawLine( right, 9, 8, bottom );           // right slant
            g.drawLine( 7, bottom, 7, bottom );          // fill-in dot

            g.translate( -x, -y );
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    static class SliderVerticalThumbIcon implements Icon, Serializable {
        public void paintIcon( Component c, Graphics g, int x, int y ) {
            JSlider slider = (JSlider)c;
            if ( !(slider.getUI() instanceof MacSliderUI) ) {
                return;
            }
            MacSliderUI ui = (MacSliderUI)slider.getUI();

            g.translate( x, y );

            int right = getIconWidth() - 1;
            int bottom = getIconHeight() - 1;            
/*
            "ScrollBar.thumb", getAccentHighlight(),
            "ScrollBar.thumbShadow", getAccent(),            
            "ScrollBar.thumbDarkShadow", getAccentShadow(),
            "ScrollBar.thumbHighlight", getAccentLightHighlight(),
            "ScrollBar.thumbLightHighlight", getGray0(),
            
            "ScrollBar.pressedThumb", getAccent(),
            "ScrollBar.pressedThumbShadow", getAccentShadow(),            
            "ScrollBar.pressedThumbDarkShadow", getAccentDarkShadow(),
            "ScrollBar.pressedThumbHighlight", getAccentHighlight(),
            "ScrollBar.pressedThumbLightHighlight", getAccentLightHighlight(),
*/
            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccent() :
                            MacLookAndFeel.getAccentHighlight() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray2() );
            }
            g.fillRect( 1, 1, 10, 13 );                  // main background fill
            g.fillRect( 11, 3, 2, 9 );                   // more background fill
            g.drawLine( 13, 6, 13, 8 );                  // more background fill

            g.setColor( ui.thumbPressed ?
                        MacLookAndFeel.getGray2() :
                        MacLookAndFeel.getGray0() );
            g.drawLine( 1, 1, 1, 1 );
            g.drawLine( 3, 4, 3, 4 );
            g.drawLine( 3, 6, 3, 6 );
            g.drawLine( 3, 8, 3, 8 );

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentHighlight() :
                            MacLookAndFeel.getAccentLightHighlight() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray3() );
            }
            g.drawLine( 1, 2, 1, bottom - 2 );           // left highlight
            g.drawLine( 2, 1, 9, 1 );                    // top highlight
            g.drawLine( 4, 4, 8, 4 );                    // top-center highlight
            g.drawLine( 4, 6, 8, 6 );                    // center-center highlight
            g.drawLine( 4, 8, 8, 8 );                    // bottom-center highlight

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentShadow() :
                            MacLookAndFeel.getAccent() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray3() );
            }
            g.drawLine( 10, 2, 14, 6 );                  // top slant shadow
            g.drawLine( 14, 7, 14, 7 );                  // fill dot
            g.drawLine( 10, bottom - 2, 14, 8 );         // bottom slant shadow
            g.drawLine( 2, bottom - 1, 9, bottom - 1 );    // bottom shadow

            if ( slider.isEnabled() ) {
                g.setColor( ui.thumbPressed ?
                            MacLookAndFeel.getAccentDarkShadow() :
                            MacLookAndFeel.getAccentShadow() );
            }
            else {
                g.setColor( MacLookAndFeel.getGray5() );
            }
            g.drawLine( 4, 5, 9, 5 );                    // top-center shadow
            g.drawLine( 4, 7, 9, 7 );                    // center-center shadow
            g.drawLine( 4, 9, 9, 9 );                    // bottom-center shadow

            g.setColor( MacLookAndFeel.getBlack() );
            g.drawLine( 0, 1, 0, bottom - 1 );           // left
            g.drawLine( 1, 0, 9, 0 );                    // top
            g.drawLine( 1, bottom, 9, bottom );          // bottom
            g.drawLine( 9, bottom, right, 8 );           // bottom slant
            g.drawLine( 9, 0, right, 6 );                // top slant
            g.drawLine( right, 7, right, 7 );            // fill-in dot

            g.translate( -x, -y );
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

}
