/*
 * @(#)MacProgressBarUI.java	1.00 98/08/08
 *
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;
import java.awt.*;

/**
 * The Mac implementation of ProgressBarUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.00 08/08/98
 * @author Luca Lutterotti
 */
public class MacProgressBarUI extends BasicProgressBarUI {

    public static ComponentUI createUI(JComponent c) {
        return new MacProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        BoundedRangeModel model = progressBar.getModel();

        int barRectX = 1;
        int barRectY = 1;
        int barRectWidth = progressBar.getWidth()-1;
        int barRectHeight = progressBar.getHeight()-1;
        Insets b = progressBar.getInsets(); // area for border
        barRectX += b.left;
        barRectY += b.top;
        barRectWidth -= (b.right + barRectX);
        barRectHeight -= (b.bottom + barRectY);

        int current;
        // a cell and its spacing
        int increment = getCellLength() + getCellSpacing();
        // amount of progress to draw
        int amountFull = getAmountFull(b, barRectWidth, barRectHeight);

        g.setColor(progressBar.getForeground());
        if (progressBar.getOrientation() == JProgressBar.HORIZONTAL) {
            //Black Border
            g.setColor(MacLookAndFeel.getBlack());
            g.drawRect(barRectX-1,barRectY-1,
                       barRectWidth+1,barRectHeight+1);

            // draw the cells
//	  if (getCellSpacing() == 0 && amountFull > 0) {
            // Highlighting
            //     over the unfilled portion
            //     well, draw all the way across; let others draw over it
            g.setColor(MacLookAndFeel.getGray3());
            g.fillRect(barRectX+amountFull,barRectY,
                       barRectWidth-1-amountFull,barRectHeight-1);

            //     line on left
            g.setColor(MacLookAndFeel.getGray9());
            g.drawLine(barRectX+amountFull+1,barRectY,
                       barRectX+amountFull+1,barRectHeight+barRectY-1);
            //     line on left
            g.setColor(MacLookAndFeel.getGray6());
            g.drawLine(barRectX+amountFull+2,barRectY,
                       barRectX+amountFull+2,barRectHeight+barRectY-1);

            //     line on right
            g.setColor(MacLookAndFeel.getGray1());
            g.drawLine(barRectWidth+barRectX-1,barRectY,
                       barRectWidth+barRectX-1,barRectHeight);

            //     line on top
            g.setColor(MacLookAndFeel.getGray6());
            g.drawLine(barRectX+amountFull+3,barRectY,
                       barRectWidth+barRectX-1,barRectY);

            //     line on bottom
            g.setColor(MacLookAndFeel.getGray1());
            g.drawLine(barRectX+amountFull+3,barRectHeight+barRectY-1,
                       barRectWidth+barRectX-1,barRectHeight+barRectY-1);

            // draw one big Rect because there is no space between cells
            g.setColor(MacLookAndFeel.getAccent());
            g.fillRect(barRectX, barRectY,
                       barRectX-b.left+amountFull, barRectHeight);
            if (amountFull-b.left > 5) {
                g.setColor(MacLookAndFeel.getBlack());

                g.drawLine(barRectX+amountFull,barRectY,
                           barRectX+amountFull,barRectHeight+barRectY-1);


                g.setColor(MacLookAndFeel.getAccentDarkShadow());

                g.drawLine(barRectX+2,barRectHeight+barRectY-1,
                           barRectX+amountFull-1,barRectHeight+barRectY-1);

                g.drawLine(barRectX+amountFull-1,barRectY+1,
                           barRectX+amountFull-1,barRectHeight+barRectY-2);


                g.setColor(MacLookAndFeel.getAccentShadow());
                g.drawLine(barRectX+2,barRectY,
                           barRectX+amountFull-1,barRectY);

                g.drawLine(barRectX+2,barRectHeight+barRectY-2,
                           barRectX+amountFull-2,barRectHeight+barRectY-2);

                g.drawLine(barRectX+amountFull-2,barRectY+2,
                           barRectX+amountFull-2,barRectHeight+barRectY-3);

                g.drawLine(barRectX+1,barRectHeight+barRectY-1,
                           barRectX+1,barRectHeight+barRectY-1);


                g.setColor(MacLookAndFeel.getAccentHighlight());
                g.drawLine(barRectX+2,barRectY+2,
                           barRectX+amountFull-3,barRectY+2);

                g.drawLine(barRectX+2,barRectHeight+barRectY-4,
                           barRectX+amountFull-3,barRectHeight+barRectY-4);

                g.drawLine(barRectX+1,barRectHeight+barRectY-3,
                           barRectX+1,barRectHeight+barRectY-3);
                g.drawLine(barRectX+1,barRectY+1,
                           barRectX+1,barRectY+1);


                g.setColor(MacLookAndFeel.getAccentLightHighlight());
                g.drawLine(barRectX+2,barRectY+3,
                           barRectX+amountFull-3,barRectY+3);

                g.drawLine(barRectX+2,barRectHeight+barRectY-5,
                           barRectX+amountFull-3,barRectHeight+barRectY-5);

                g.drawLine(barRectX+amountFull-3,barRectY+4,
                           barRectX+amountFull-3,barRectHeight+barRectY-6);

                g.drawLine(barRectX+1,barRectHeight+barRectY-4,
                           barRectX+1,barRectHeight+barRectY-4);
                g.drawLine(barRectX+1,barRectY+2,
                           barRectX+1,barRectY+2);

                g.setColor(MacLookAndFeel.getWhite());
                g.fillRect(barRectX+2, barRectY+4,
                           barRectX-b.left+amountFull-5, barRectHeight-9);
                g.drawLine(barRectX+1,barRectY+3,
                           barRectX+1,barRectHeight+barRectY-5);
            }
//	    } else { // draw each individual cells
            // the largest number to draw a cell at
//		int max = barRectX + amountFull;

/*		for (current = barRectX;
             current < max;
             current += increment) {
        g.setColor(MacLookAndFeel.getAccent());
            g.fillRect(current, barRectY,
                   getCellLength(), barRectHeight);
        }*/
//	    }
        } else { // VERTICAL

            //Black Border
            g.setColor(MacLookAndFeel.getBlack());
            g.drawRect(barRectX-1,barRectY-1,
                       barRectWidth+1,barRectHeight+1);

            // draw the cells
//	  if (getCellSpacing() == 0 && amountFull > 0) {
            // Highlighting
            //     over the unfilled portion
            //     well, draw all the way across; let others draw over it
            g.setColor(MacLookAndFeel.getGray3());
            g.fillRect(barRectX,barRectY+amountFull,
                       barRectWidth-1,barRectHeight-1-amountFull);

            //     line on left
            g.setColor(MacLookAndFeel.getGray9());
            g.drawLine(barRectX,barRectY+amountFull+1,
                       barRectX+barRectWidth-1,barRectY+amountFull+1);
            //     line on left
            g.setColor(MacLookAndFeel.getGray6());
            g.drawLine(barRectX,barRectY+amountFull+2,
                       barRectX+barRectWidth-1,barRectY+amountFull+2);

            //     line on right
            g.setColor(MacLookAndFeel.getGray1());
            g.drawLine(barRectWidth+barRectX-1,barRectY,
                       barRectWidth+barRectX-1,barRectHeight);

            //     line on top
            g.setColor(MacLookAndFeel.getGray6());
            g.drawLine(barRectX,barRectY+amountFull+3,
                       barRectWidth+barRectX-1,barRectY+amountFull+3);

            //     line on bottom
            g.setColor(MacLookAndFeel.getGray1());
            g.drawLine(barRectX,barRectHeight+barRectY-1,
                       barRectWidth+barRectX-1,barRectHeight+barRectY-1);

            // draw one big Rect because there is no space between cells
            g.setColor(MacLookAndFeel.getAccent());
            g.fillRect(barRectX, barRectY,
                       barRectWidth, barRectHeight-b.top+amountFull);
            if (amountFull-b.top > 5) {
                g.setColor(MacLookAndFeel.getBlack());

                g.drawLine(barRectX,barRectY+amountFull,
                           barRectWidth+barRectX-1,barRectY+amountFull);


                g.setColor(MacLookAndFeel.getAccentDarkShadow());

                g.drawLine(barRectWidth+barRectX-1,barRectY+2,barRectWidth+barRectX-1, barRectY
                           +amountFull-1);

                g.drawLine(barRectX+1,barRectY+amountFull-1,barRectHeight+barRectX-2, barRectY+
                           amountFull-1);


                g.setColor(MacLookAndFeel.getAccentShadow());

                g.drawLine(barRectX,barRectY+2,barRectX, barRectY+amountFull-1);

                g.drawLine(barRectWidth+barRectX-2,barRectY+2,barRectWidth+barRectX-2, barRectY
                           +amountFull-2);

                g.drawLine(barRectX+2,barRectY+amountFull-2,barRectWidth+barRectX-3, barRectY+amountFull-2);

                g.drawLine(barRectWidth+barRectX-1,barRectY+1,barRectWidth+barRectX-1, barRectY
                           +1);


                g.setColor(MacLookAndFeel.getAccentHighlight());

                g.drawLine(barRectX+2,barRectY+2,barRectX+2, barRectY+amountFull-3);

                g.drawLine(barRectWidth+barRectX-4,barRectY+2,barRectWidth+barRectX-4, barRectY
                           +amountFull-3);

                g.drawLine(barRectWidth+barRectX-3,barRectY+1,barRectWidth+barRectX-3, barRectY
                           +1);

                g.drawLine(barRectX+1,barRectY+1,barRectX+1, barRectY+1);


                g.setColor(MacLookAndFeel.getAccentLightHighlight());

                g.drawLine(barRectX+3,barRectY+2,barRectX+3, barRectY+amountFull-3);
                g.drawLine(barRectWidth+barRectX-5,barRectY+2,barRectWidth+barRectX-5,
                           barRectY+amountFull-3);

                g.drawLine(barRectX+4,barRectY+amountFull-3,barRectWidth+barRectX-6, barRectY+amountFull-3);

                g.drawLine(barRectWidth+barRectX-4,barRectY+1,barRectWidth+barRectX-4, barRectY
                           +1);

                g.drawLine(barRectX+2,barRectY+1,barRectX+2, barRectY+1);

                g.setColor(MacLookAndFeel.getWhite());
                g.fillRect(barRectX+4,barRectY+2 ,
                           barRectWidth-9,barRectX-b.left+amountFull-5);

                g.drawLine(barRectX+3,barRectY+1,barRectWidth+barRectX-5,
                           barRectY+1);
            }


        }

        // Deal with possible text painting
        if (progressBar.isStringPainted()) {
            paintString(g, barRectX, barRectY,
                        barRectWidth, barRectHeight,
                        amountFull, b);
        }
    }

}
