/*
 * @(#)MetalScrollButton.java	1.12 98/05/15
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Polygon;

import javax.swing.*;

import javax.swing.plaf.basic.BasicArrowButton;


/**
 * JButton object for Mac scrollbar arrows.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.12 05/15/98
 * @author Tom Santos
 */
public class MacScrollButton extends BasicArrowButton {
    private static Color background;
    private static Color highlight;
    private static Color shadow;
    private static Color pressedBackground;
    private static Color pressedHighlight;
    private static Color pressedShadow;
    private static Color arrowColor;

    private int buttonWidth;

    public MacScrollButton( int direction, int width )
    {
        super( direction );

        background         = UIManager.getColor("ScrollBar.arrowBackground");
        highlight          = UIManager.getColor("ScrollBar.arrowHighlight");
        shadow             = UIManager.getColor("ScrollBar.arrowShadow");
        pressedBackground  = UIManager.getColor("ScrollBar.pressedArrowBackground");
        pressedHighlight   = UIManager.getColor("ScrollBar.pressedArrowHighlight");
        pressedShadow      = UIManager.getColor("ScrollBar.pressedArrowShadow");
        arrowColor         = UIManager.getColor("ScrollBar.arrowColor" );

        buttonWidth = width;
    }

    public void paint( Graphics g )
    {
        ButtonModel model = getModel();
        boolean isArmedAndPressed = model.isArmed() && model.isPressed();

        if ( isEnabled() ) {
            g.setColor( isArmedAndPressed ? pressedBackground : background );
        }
        else {
            g.setColor( MacLookAndFeel.getGray0() );
        }
        g.fillRect( 0, 0, buttonWidth, buttonWidth );

        if ( isEnabled() ) {
            g.setColor( isArmedAndPressed ? pressedShadow : highlight );
            g.drawLine( 0, 0, buttonWidth - 2, 0 ); 
            g.drawLine( 0, 0, 0, buttonWidth - 2 );

            g.setColor( isArmedAndPressed ? pressedHighlight : shadow );
            g.drawLine( buttonWidth - 1, 1, buttonWidth - 1, buttonWidth - 1 );
            g.drawLine( 1, buttonWidth - 1, buttonWidth - 1, buttonWidth - 1 );
        }
        else {
            g.setColor( MacLookAndFeel.getGray9() );

            switch ( getDirection() ) {
            case NORTH:
                g.drawLine( 0, buttonWidth - 1, buttonWidth - 1, buttonWidth - 1 );
                break;
            case SOUTH:
                g.drawLine( 0, 0, buttonWidth - 1, 0 ); 
                break;
            case EAST:
                g.drawLine( 0, 0, 0, buttonWidth - 1 );
                break;
            case WEST:
                g.drawLine( buttonWidth - 1, 0, buttonWidth - 1, buttonWidth - 1 );
                break;
            }
        }

        g.setColor( isEnabled() ? arrowColor : MacLookAndFeel.getGray6() );

        switch ( getDirection() ) {
        case NORTH:
            g.drawLine( 6, 5, 7, 5 );
            g.drawLine( 5, 6, 8, 6 );
            g.drawLine( 4, 7, 9, 7 );
            g.drawLine( 3, 8, 10, 8 );
            break;
        case SOUTH:
            g.drawLine( 3, 5, 10, 5 );
            g.drawLine( 4, 6, 9, 6 );
            g.drawLine( 5, 7, 8, 7 );
            g.drawLine( 6, 8, 7, 8 );
            break;
        case WEST:
            g.drawLine( 5, 6, 5, 7 );
            g.drawLine( 6, 5, 6, 8 );
            g.drawLine( 7, 4, 7, 9 );
            g.drawLine( 8, 3, 8, 10 );
            break;
        case EAST:
            g.drawLine( 5, 3, 5, 10 );
            g.drawLine( 6, 4, 6, 9 );
            g.drawLine( 7, 5, 7, 8 );
            g.drawLine( 8, 6, 8, 7 );
            break;
        }
    }

    public Dimension getPreferredSize()
    {
        return new Dimension( buttonWidth, buttonWidth );
    }

    public Dimension getMinimumSize()
    {
        return getPreferredSize();
    }

    public Dimension getMaximumSize()
    {
        return new Dimension( Integer.MAX_VALUE, Integer.MAX_VALUE );
    }
}

