/*
 * @(#)MetalSeparatorUI.java	1.8 98/05/18
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.BasicSeparatorUI;


/**
 * A Mac L&F implementation of SeparatorUI.  This implementation 
 * is a "combined" view/controller.
 * @version 1.8 05/18/98
 * @author Steve Wilson
 */

public class MacSeparatorUI extends BasicSeparatorUI {
    public static ComponentUI createUI( JComponent c )
    {
        return new MacSeparatorUI();
    }

    protected void installDefaults( JSeparator s )
    {
        LookAndFeel.installColors( s, "Separator.background", "Separator.foreground" );
    }

    public void paint( Graphics g, JComponent c )
    {
        int h = c.getHeight();
        int w = c.getWidth();

        Color dark = c.getForeground();
        Color light = c.getBackground();

        if ( ((JSeparator)c).getOrientation() == JSeparator.VERTICAL ) {

         // ?????

        } else {  // HORIZONTAL
            g.setColor( light );
            g.drawLine( 0, 0, 0, h-1 );

            g.setColor( dark );
            g.drawLine( w-1, 0, w-1, h-1 );
            g.drawLine( 0, 2, w-1, 2);

            g.setColor(light);
            g.drawLine(0, 3, w-1, 3);
        }
    }

    public Dimension getPreferredSize( JComponent c )
    { 
        if ( ((JSeparator)c).getOrientation() == JSeparator.VERTICAL )
            return new Dimension( 6, 0 );
        else
            return new Dimension( 0, 6 );
    }
}

